function [data, properties] = readTexoRF(fileName, frameInit, frameEnd)
% 
% function [data, properties] = readTexoRF(fileName, frameInit, frameEnd)
%
% Reads RF data acquired in custom mode and provides data frames from frameInit
% to frameEnd, and a header providing acquisition details.
% 
% Jean Martial Mari 2007-2008
% Imperial College London
%

fid = fopen(fileName, 'r');

disp('----------------------------------------------------');

properties.frameSize = fread(fid, 1, 'int32');
properties.nbElements =  fread(fid, 1, 'int32');
properties.nbLines =  fread(fid, 1, 'int32');
properties.sectorial = fread(fid, 1, 'int32');
properties.scanningMode = fread(fid, 1, 'int32');
% scanningMode : - 1: basic RF Mode.
%                - 2: PI Mode.
%                - 3: Doppler Mode.

properties.subMode = fread(fid, 1, 'int32');
% basic RF Mode: subMode - 1: basic RF Mode
%						  - 2: high speed
%						  - 3: M mode
% Doppler: subMode 1: Doppler M + B mode frame.

properties.frameRate = fread(fid, 1, 'int32');
properties.txFreq = fread(fid, 1, 'int32');
properties.txFocus = fread(fid, 1, 'int32');
properties.rxDepth = fread(fid, 1, 'int32');
properties.numberDopplerLines = fread(fid, 1, 'int32');

if (properties.sectorial)
    disp('- Phased array data -')
else
    disp('- Linear array data -')
end

properties.lineSize = (properties.frameSize-4)/properties.nbLines/2;


for i = 1:(frameInit-1)
    head = fread(fid, 4, 'uchar');%double
    (fread(fid, [properties.lineSize, properties.nbLines], 'short'));
end

for i = frameInit:frameEnd
    head = fread(fid, 4, 'uchar');%double
    data(i-frameInit+1, :,:) = (fread(fid, [properties.lineSize, properties.nbLines], 'short'))';
end

fclose(fid);

disp('----------------------------------------------------');