%A function for making a region-of-interest (ROI) at an angle to the whole
%figure

%K H Fraser, C Poelma 2016
function [X Y]=rectROI(width,height,centre,a)

x=centre(1);y=centre(2);

a=a*pi/180;

ULx=x+(width/2)*cos(a)-(height/2)*sin(a);ULy=y+(height/2)*cos(a)+(width/2)*sin(a);
URx=x-(width/2)*cos(a)-(height/2)*sin(a);URy=y+(height/2)*cos(a)-(width/2)*sin(a);
BLx=x+(width/2)*cos(a)+(height/2)*sin(a);BLy=y-(height/2)*cos(a)+(width/2)*sin(a);
BRx=x-(width/2)*cos(a)+(height/2)*sin(a);BRy=y-(height/2)*cos(a)-(width/2)*sin(a);
X=[BLx BRx URx ULx BLx];
Y=[BLy BRy URy ULy BLy];