addpath('X:\Physics\ResearchProjects\AGorbach\EB-PH1141\Working\Year_1\Code\useful_functions')

fwhm = 1.6e-2
lam_p = 0.7184
signal = 1.55
idler = 1.337 
sigma = fwhm / (2*sqrt(2*log(2)));
color = 'm'
[wl1, wl2] = meshgrid(wlgen, wlgen);  
for j = 1:ng, pump_thin(j) = -lam_p*wlgen(j) / (lam_p - wlgen(j)); end      
lam_p = ones(ng, ng) * lam_p;  
pump = exp(-(lam_p - wl1.*wl2 ./ (wl1 + wl2)).^2 / (2*sigma^2)) / (sigma*sqrt(2*pi));




subplot(2,2,1) 
sigma2 = 1.e-3
pump2 = exp(-(lam_p - wl1.*wl2 ./ (wl1 + wl2)).^2 / (2*sigma2^2)) / (sigma*sqrt(2*pi));
pp = matrepeat(pump2, 3); 
cross = squeeze((squeeze(abs(sum(A .* pp, 2))))); 
for j = 1:3
    cross(:,j) = cross(:,j) / max(cross(:,j));
end
H = plot(wlgen, cross.^2 / 0.546) 
ylabel('Intensity (A.U)') 
xlabel('\lambda_s (\mum)')
H(1).Color = [0 0 0 1]
H(2).Color = [1 0 0 0.7]
H(3).Color = [0 0 1 0.4]

h = legend(num2str(ratio'));
%h.Postion = [0.3558, 0.8077, 0.0944, 0.0831];
h.LineWidth = 0.5
%h.Box = 'off'

hlt = text('Parent', h.DecorationContainer, 'String', 'Taper Ratio','HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom', 'Position', [0.5, 1.0, 0], 'Units', 'normalized');
xlim([1.45 1.65])
ylim([0 1])
%axis square
%keyboard 


subplot(2,2,2) 
ww = profile(0.5); 
x = linspace(0, 200, nw);
[xq, yq, zq] = meshgrid(idler, signal, ww) 
p = squeeze(interp3(lgen, lgen, width, rho, xq, yq, zq, 'spline'));
[Ax, H1, H2] = plotyy(x, ww, x, imag(p)/8.184e25) 
xlabel(Ax(1), 'y (\mum)')
ylabel(Ax(1), 'w(y) (\mum)')
ylabel(Ax(2), '\rho_2 (A.U)')
H2(1).LineStyle = '--'
H2(1).Color = 'k'
H1(1).Color = 'r'
Ax(1).YColor = 'r' 
Ax(2).YColor = 'k'
ylim(Ax(1), [0. 0.54])
ylim(Ax(2), [0. 1.1])
breakxaxis(Ax(2), [70 130])
breakxaxis(Ax(1), [70 130])


subplot(2,2,3)
pcolor(wlgen, wlgen, abs(A(:,:,3) / 1.1850e+28 .* pump).^2 / 3.2956e+03 ), shading interp
xlim([1.45 1.65])
ylim([1.25 1.45])
xlabel('\lambda_s (\mum)')
ylabel('\lambda_i (\mum)')
colormap(flip(bone))
caxis([0 0.1])
set(gca, 'Layer','top')
hold on 

plot(wlgen, pump_thin, 'r--');
X = [0.30382 0.30729]
Y = [0.249 0.49598]
arrow = annotation('arrow')
arrow.Color = 'r'
arrow.X = [0.3071 0.3073]
arrow.Y = [0.2619 0.4960]

subplot(2,2,4)
[Ax, H1, H2] = plotyy(lamP, vis_A, lamP, [id, sig])
xlabel(Ax(1), '\lambda_{pump} (\mum)')
ylabel(Ax(1), 'Photon Purity')
ylabel(Ax(2), '\lambda_s / \lambda_i')
ylabel(Ax(2), '\lambda_s / \lambda_i (\mum)' )
xlim(Ax(1), [0.7 0.75])
xlim(Ax(2), [0.7 0.75])
%xlim(Ax(2), [0.66 0.83])
%xlim(Ax(1), [0.66 0.83])
%ylim(Ax(2), [1.2 1.6])
ylim(Ax(1), [0.4 1.])
ylim(Ax(2), [1.3 1.6])
Ax(2).YColor = color
Ax(2).YTick = linspace(1.3, 1.6, 6);
%Ax(2).YTickLabel = []
Ax(1).YTick = linspace(0.4, 1, 7);

H2(1).LineStyle = '--'
H2(1).Color = color
H2(2).LineStyle = '--'
H2(2).Color = color

%H1(1).LineStyle = ''
H1(1).Color = [0 0 0 1]
H1(2).Color = [1 0 0 0.7]
H1(3).Color = [0 0 1 0.4]


%f=getframe; imwrite(f.cdata,'PEnocolor.png');
% put in abcd 
a1 = annotation('textbox','String','a)')
a1.LineStyle = 'none'
a1.Position = [0.135 0.9248 0. 0.]

a2 = annotation('textbox','String','b)')
a2.LineStyle = 'none'
a2.Position = [0.575 0.9248 0. 0.]


a3 = annotation('textbox','String','c)')
a3.LineStyle = 'none'
a3.Position = [0.135 0.448 0. 0.]

a4 = annotation('textbox','String','d)')
a4.LineStyle = 'none'
a4.Position = [0.575 0.448 0. 0.]







