function  [ AA, vis_A, id, sig] = taper_calculate2(ww, fwhm)
% function to return the visability of (initially with no pump) of a
% particular width profile


global ng  ngen npump lpump lgen width wlgen rho nsweep %hbar epsilon c d33

d33 = 19E-12 
c = 3.e8
epsilon = 8.854e-12
hbar = 1.05457e-34

[dummy, nw] = size(ww)
dz = 200 / nw
wlint = [1.2, 1.8];
wlgen = linspace(wlint(1), wlint(2), ng); 

[xq, yq] = meshgrid(ww, wlgen);
%keyboard 
n1 = interp2(width, lgen, ngen, xq, yq, 'spline');
n2 = zeros(ng, ng, nw);
n2 = matrepeat(n1, ng);
n2 = permute(n2, [1 3 2]);
n1 = permute(n2, [2 1 3]); 
%keyboard
%----calculates pump wavelength for given wavelength----------------------%
% then interpolates corisponding refractive indices
[wlgenx, wlgeny] = meshgrid(wlgen, wlgen);
wlpump = wlgenx .* wlgeny ./ (wlgenx + wlgeny);
%keyboard
xq = squeeze(matrepeat(matrepeat(ww,ng),ng));
xq = permute(xq, [3 2 1]);
yq = matrepeat(wlpump, nw);
%[yq, xq] = meshmat(wlpump, ww, [1 2 3]); 
n3 = interp2(width, lpump, npump, xq, yq, 'spline'); 
clear wlgenx wlgeny



%----then rho and lambdas-------------------------------------------------% 

zq = xq;
xq = squeeze(matrepeat(matrepeat(wlgen, ng),nw));
yq = permute(xq, [2 1 3]);

%[xq, yq, zq] = meshgrid(wlgen, wlgen, ww); 
%[xq, yq, zq] = meshgrid(wlgen, wlgen, ww);

p = interp3(lgen, lgen, width, rho, xq, yq, zq, 'spline');
p = smooth3(p);
wlpump = matrepeat(wlpump, nw);
[wl1, wl2, dummy] = meshgrid(wlgen, wlgen, ww); 
%}

%----now we can calculate db----------------------------------------------% 
db = 2*pi*(n3 ./ wlpump - n1 ./ wl1 - n2 ./ wl2);

wl3 = squeeze(wlpump(:,:,1));
[wl1, wl2] = meshgrid(wlgen, wlgen);
%wl1 = wl1*1e-6;
%wl2 = wl2*1e-6;
neff1 = squeeze(n1(:,:,1));
neff2 = squeeze(n2(:,:,1));
neff3 = squeeze(n3(:,:,1));
phi = zeros(ng,ng,nw);

for j = 1:nw
    phi(:,:, j) = sum(db(:,:,1:j), 3) * dz;
end
A = 1i * sum( dz * p .* exp(1i*phi) .* exp(1i .* db * dz / 2) .* sinc(db * dz / (2*pi)), 3) * 1.e-6;

%keyboard

AA = A;
%renormalisation
%A = AA ./ sqrt(wl1 .* wl2 .* wl3);
%keyboard
%pcolor(abs(A.^2)), shading interp;
%multiply by pump function 
lamP = linspace(0.66, 0.8, nsweep); 
%fwhm = 1.4e-2 %fwhm of pump(lambda[um]) %1.2 for best at 0.35
sigma = fwhm / (2*sqrt(2*log(2)));

vis1 = zeros(nsweep,1);
vis2 = vis1;

tic 

vis_A = zeros(nsweep,1);
sig = vis_A; 
id = sig;
for k = 1:nsweep
    pump = exp(-(lamP(k) - wl1.*wl2 ./ (wl1 + wl2)).^2 / (2*sigma^2)) / (sigma*sqrt(2*pi));
    vis_A(k) = vis(pump .* A);
    subplot(2,1,1)
    pcolor(abs(pump .* A )), shading interp
    subplot(2,1,2)
    plot(lamP(1:k), squeeze(vis_A(1:k)));
    pause(0.0001)
    %keyboard
    [dummy, a] = max(triu(pump .* A));
    [dummy2, b] = max(dummy);
    sig(k) = wlgen(a(b));
    [dummy, a] = max(tril(pump .* A));
    [dummy2, b] = max(dummy);
    id(k) = wlgen(a(b));
    %break
end
%keyboard 

% renormalise the Wei way:
e0 = 8.85E-12
c = 3E8 
hbar = 1.05E-34
omega_p = 2* pi * c ./ squeeze(wlpump(:,:,1)*1E-6);
neff_p = squeeze(n3(:,:,1)); 
%wei = pi^2 * e0 * c * neff_p ./ (hbar * omega_p); 


A = A %./ sqrt(wei); 


    


