%-----sweeps for eff------------------------------------------------------%
% This code sould be able to calculate everything for a range of waveguide
% widths and wavelengths.
%
% pchip extrapolation hopefully the most stable?                           
%
% get initial conditions from gui                   
%
% in this version all the lpump points are caluculated for a particular
% width then all the lgen points are calculated to take advantage of 
% using the previous feild in the solver.
%
% other changes - if condition to flip the sign of the feilds to a version
% that seems to work 
%-------------------------------------------------------------------------$

%clear all
%close all
global XX ngrid model hbar


%-----loads constant model parameters-------------------------------------%
hbar = 1.0546E-32 % hbar in S.I units 

aCore = 0.35;
height = 0.3; 
dead = 0.16 % thickness of dead layer 
gen_int = [1.8, 1.2] %1.2
pump_int = gen_int / 2 
width_int = [0.43, 0.41]
n_int = [ 1.4205 1.3] % initial effective index [generated,pump] 
steps_w = 10
steps_l = 60
delta = 0.0 %small parameter to avoid large edge feilds 
ngrid = 50
%% 
model = mphload('taper_mod');
model.param.set('height', strcat(num2str(height), '[um]'));
model.param.set('aCore', strcat(num2str(aCore), '[um]'));    
model.study('std1').feature('mode').set('neigs', '1');
%%
%------Initialize some variables------------------------------------------%
lpump = linspace(pump_int(1), pump_int(2), steps_l); 
lgen = linspace(gen_int(1), gen_int(2), steps_l); 
width = linspace(width_int(1), width_int(2), steps_w); 
disp('Are you sure you want to run (Data may be overwritten)?')
pause

egen = zeros(ngrid^2, steps_l, steps_w);
epump = zeros(ngrid^2, steps_l, steps_w);
npump = zeros(steps_l, steps_w);
ngen = zeros(steps_l, steps_w);

%-----y coordinates for feild call----------------------------------------%
y1 = -aCore - height; %-3.*aCore-height;
y2 = -aCore - dead;  %3.*aCore-height;
yrange = linspace( y1, y2, ngrid);



%% ---run main sweep------------------------------------------------------%
ng_prev = n_int(1);
np_prev = n_int(2);
ng_next = ng_prev; 
np_next = np_prev;
E = egen(:, 1, 1);
figure
for j = 1:steps_w, 
    %----x coordinates for feild call-------------------------------------%
    x1 = -(width(j) - delta)/2;
    x2 = (width(j) - delta) /2; 
    xrange = linspace( x1, x2, ngrid);
    [X, Y] = meshgrid(xrange*1e-6, yrange*1e-6); 
    XX = [X(:), Y(:)]';
 
    %% runs sweep
    tic
    for k = 1:steps_l  
        % runs model and extracts feild-----------------------------------%
        model.param.set('width', strcat(num2str(width(j)), '[um]'));
        model.param.set('Lambda', strcat(num2str(lpump(k)), '[um]'));
        model.study('std1').feature('mode').set('shift', num2str(np_next));
        model.study('std1').run;
        %mphglobal(model, 'ewfd.neff')
        npump(k,j) = mphglobal(model, 'ewfd.neff');
        epump(:,k,j) = ex_field();
        
        %----this section trys to accurately predict the next point ------%
        if k > 1 && k < 4
            np_next = interp1(npump(1:k, j), k + 1, 'linear', 'extrap');
        elseif k > 3
            % once some points have been generated matlab's 
            % interpolation routines can produce accurate results 
            if j < 5
                np_next = interp1(npump(1:k, j), k + 1, 'pchip', 'extrap');
            elseif k < steps_l 
                np_next = interp1(npump(k+1, 1:j-1),j, 'pchip', 'extrap');
            end 
        else
            if j > 1  
                np_next = npump(k+1,j-1);                      
            elseif j ==1  
                np_next = npump(k,j) - 0.002;
            end
        end
        np_prev = npump(k,j);
       
        
        %some output while the code is running----------------------------%
        % This bit of code outputs the the mode profile for each mode along
        % with the dispersion relation including the guess for the next 
        % next step of the solver
        subplot(2,2,1); 
        delta = lgen(2) - lgen(1);
        E = reshape(squeeze(epump(:,k,j)), [ngrid ngrid]);
        pcolor(imag(E)), shading interp;
        subplot(2,2,2); 
        plot(lgen(1:k), squeeze(npump(1:k, j)), lgen(k) + delta, np_next, '*');
        pause(0.001);
        %------------------------------------------------------------------
        toc
    end
 
        %% runs sweep2 
    for k = 1:steps_l;     
        % runs model and extracts feild-----------------------------------%
        model.param.set('width', strcat(num2str(width(j)), '[um]'));        
        model.param.set('Lambda', strcat(num2str(lgen(k)), '[um]'));
        model.study('std1').feature('mode').set('shift', num2str(ng_next));
        model.study('std1').run;
        ngen(k,j) = mphglobal(model, 'ewfd.neff');
        toc
        egen(:,k,j) = ex_field();
        %mphglobal(model, 'ewfd.neff')
        %keyboard 
        
        %----this section trys to accurately predict the next point ------%
        if k > 1 && k < 4
            ng_next = interp1(ngen(1:k, j), k + 1, 'linear', 'extrap');
        elseif k > 3
            % once some points have been generated matlab's 
            % interpolation routines can produce accurate results 
            ng_next = interp1(ngen(1:k, j), k + 1, 'pchip', 'extrap');
        else
            ng_next = ngen(k,j);
        end
        ng_prev = ngen(k,j);
        %{
        if ng_next < ngen(k,j)
            ng_next = ngen(k,j);
        end 
        if np_next < npump(k,j)
            np_next = ngen(k,j);
        end
        %}
        j,k
        
        %some output while the code is running----------------------------%
        % This bit of code outputs the the mode profile for each mode along
        % with the dispersion relation including the guess for the next 
        % next step of the solver
        subplot(2,2,3); 
        E = reshape(squeeze(egen(:,k,j)), [ngrid ngrid]);
        pcolor(imag(E)), shading interp
        subplot(2,2,2); 
        plot(lgen(1:k), squeeze(ngen(1:k, j)), lgen, npump(:,j));
        pause(0.001);
        %------------------------------------------------------------------
        %keyboard
    end
    toc
    if j > 1 
        ng_next = 2*ngen(1,j) - ngen(1,j-1);
        np_next = 2*npump(1,j) - npump(1,j-1);
    else     
        ng_next = ngen(1,j); %2*ngen(1,j) - ngen(1,j-1);
        np_next = npump(1,j);%2*npump(1,j) - npump(1,j-1);
    end  
if j > 1
    subplot(2,2,4);
    pcolor(width(1:j), lpump, npump(:,1:j))
    pause(0.001);
end
end







t = datetime('now','TimeZone','local','Format','yyMMdd_HHmm');
t = char(t);
a = num2str(aCore*100);
s = strcat('neff_aCore=',a,'_',t)


disp('Save data before proceeding?')
keyboard


%% Calculates rho2  
%----S.I constants(sort of)-----------------------------------------------%
c = 3E14 % in units of micron/s to cancel with lambda 
epsilon = 8.854E-12
d33 = 19E-12 

steps_w = 40
steps_l = 50
height = 0.3; 
l=1

[ngrid, steps_l, steps_w] = size(epump);
ngrid = ngrid^0.5

% fun with gpu 
lgen = gpuArray(lgen);
lpump = gpuArray(lpump);
egen = gpuArray(egen);
epump = gpuArray(epump);

% Calculates the effective nonlinearity constant rho
% (you may have to manually flip the sign of some of the feilds) 
%% this section attempts to correct the sign fliping 
tic
E = epump(:, round(steps_l/2), round(steps_w/2));
for k = 1:steps_w, 
    for j = 1:steps_l; 
        flip = squeeze(sum(E .* conj(epump(:,j,k))));
        flip = flip / abs(flip)
        epump(:,j,k) = epump(:,j,k)/ flip; 
end,end
toc 

tic
E = egen(:, round(steps_l/2), round(steps_w/2));
for k = 1:steps_w, 
    for j = 1:steps_l; 
        flip = squeeze(sum(E .* conj(egen(:,j,k))));
        flip = flip / abs(flip)
        epump(:,j,k) = epump(:,j,k)/ flip; 
end,end
toc 


%% this section calculates rho from hopefully correct feilds 
rho = gpuArray.zeros(steps_l, steps_l, steps_w);
%egen = zeros(ngrid^2, steps_l, steps_w);
tic
for j = 1:steps_l
    tic
    for k = 1:steps_l
        for l = 1:steps_w
            l3 = lgen(j) * lgen(k) / (lgen(j) + lgen(k));
            [dummy, loc] = min(abs(lpump - l3)); %nearest neigbour interpolation 
            lpump(loc)
            rho(j,k,l) = squeeze(sum(conj(egen(:,j,l) .* egen(:,k,l)) .* epump(:,loc,l))); 
            rho(j,k,l) = rho(j,k,l) * height * width(l) * 1E-12 / ngrid; % integrate in S I units 
        end 
    end
    toc / (steps_l * steps_w) %average time to execute inner loop 
    j
    plot(squeeze(rho(:, k,l))); 
end
toc




% give rho in units such that rho[S.I] = rho / (l1*l2*l3[um])^0.5
% so the joint spectrum is in units of number of photons for every 
% converted Watt of power

rho = rho * epsilon * d33 / (8 * 2^0.5) ;
                                 
%run rho clean 



