%-------------------------------------------------------------------------%
% Script to calculate the rho2 coefficent based on the 
% based on rho_nsweep_combined2.m 
% requires: taper_mod.mph, ex_feild
%
% second half of code is fully vectorized and optimisted using the gpu 
%

global ngrid model hbar

%-----loads constant model parameters-------------------------------------%
aCore = 0.72;
height = 0.3; 
wwidth = 0.51 %0.5114; % waveguide width 
dead = 0.16 % thickness of dead layer 
gen_int = [1.8, 1.2] %1.2
pump_int = gen_int / 2. 
width_int = [wwidth, 0] %thickness interval for PE channel 
n_int = [ 1.2 1.3] % initial effective index [generated,pump] 
steps_w = 60   
steps_l = 20
delta = 0.0 %small parameter to avoid large edge fe
%hbar = 1.05457E-34
%ilds 
ngrid = 50
NL_frac = 0.  %fraction of chi2 active in PE-layer  
        

disp('Are you sure you want to run (Data may be overwritten)?')
pause
lpump = linspace(pump_int(1), pump_int(2), steps_l); 
lgen = linspace(gen_int(1), gen_int(2), steps_l); 
delta = lgen(2) - lgen(1);

model = mphload('taper_mod');
model.param.set('height', strcat(num2str(height), '[um]'));
model.param.set('aCore', strcat(num2str(aCore), '[um]')); 
model.param.set('width', strcat(num2str(wwidth), '[um]'));
model.study('std1').feature('mode').set('neigs', '1');
%-------------------------------------------------------------------------%

%--set grid for plot and integration -------------------------------------% 
x1 = 0 
x2 = wwidth/2  
y1 = -aCore - height; %-3.*aCore-height;
y2 = -aCore;  %3.*aCore-height;
yrange = linspace( y1, y2, 10);
xrange = linspace( x1, x2, 10);
[X, Y] = meshgrid(xrange*1e-6, yrange*1.e-6); 
YY = [X(:), Y(:)]';%plot grid 

%xrange = rand(1, ngrid)*x2;
%yrange = y2 - height*rand(1, ngrid);
%[X, Y] = meshgrid(xrange*1e-6, yrange*1e-6); 
%XX = [X(:), Y(:)]';% integration grid(monte carlo) 
XX = rand(2, ngrid^2);
XX(1,:) = XX(1,:)*x2*1e-6;
XX(2,:) = (y2 - XX(2,:)*height)*1e-6;

%-------------------------------------------------------------------------%
%%
npump = zeros(steps_l,1);
ngen = zeros(steps_l,1);
egen = zeros(ngrid^2, steps_l);
epump = zeros(ngrid^2, steps_l);
ng_next = n_int(1);
np_next = n_int(2);
for j = 1:steps_l 
%run model  
    model.param.set('Lambda', strcat(num2str(lpump(j)), '[um]'));
    model.study('std1').feature('mode').set('shift', num2str(np_next));
    model.study('std1').run;
    npump(j) = mphglobal(model, 'ewfd.neff');
    [epump(:,j), norm] = ex_field(XX);
    omega = 2*pi*mphglobal(model, 'f0');
    norm = norm * omega;
    epump(:,j) = epump(:,j) / norm^0.5; 
    [E, dummy] = ex_field(YY);
    if j > 1
        np_next = interp1(npump(1:j), j + 1, 'linear', 'extrap');
    elseif j > 5 
        np_next = interp1(npump(1:j), j + 1, 'linear', 'extrap');
    else
        np_next = npump(j); 
    end 
    
    %plot field and modal dispersion 
    subplot(2,1,1);
    E = reshape(E, [10 10]);
    pcolor(imag(E)), shading interp;
    subplot(2,1,2); 
    plot(lgen(1:j), npump(1:j), lgen(j) + delta, np_next, '*'); 
    pause(0.001)
end

%%
for j = 1:steps_l 
%run model  
    model.param.set('Lambda', strcat(num2str(lgen(j)), '[um]'));
    model.study('std1').feature('mode').set('shift', num2str(ng_next));
    model.study('std1').run;
    ngen(j) = mphglobal(model, 'ewfd.neff');
    omega = 2*pi*mphglobal(model, 'f0');
    [egen(:,j), norm] = ex_field(XX);
    egen(:,j) = egen(:,j) / norm^0.5
    E = ex_field(YY);  
    if j > 1
        ng_next = interp1(ngen(1:j), j + 1, 'linear', 'extrap');
    elseif j > 5 
        ng_next = interp1(ngen(1:j), j + 1, 'linear', 'extrap');
    else
        ng_next = ngen(j); 
    end 
    %plot field and modal dispersion 
    subplot(2,1,1);
    E = reshape(E, [10 10]);
    pcolor(imag(E)), shading interp;
    subplot(2,1,2); 
    plot(lgen, npump, lgen(1:j), ngen(1:j), lgen(j) + delta, ng_next, '*');
    pause(0.001)
end

%% Plot the phase matching condition 


%% Calculates rho2  
%----S.I constants(sort of)-----------------------------------------------%
epsilon = 8.854E-12
hbar = 1.0546E-32 
d33 = 19E-12 
c = 3.e8

lgen = gpuArray(lgen);
lpump = gpuArray(lpump);
egen = gpuArray(egen);
epump = gpuArray(epump);
rho = gpuArray.zeros(steps_l, steps_l, steps_w);
width = gpuArray.linspace(width_int(1), width_int(2), steps_w); 
int = 0; 
n1 = 0;
n2 = 0;

for j = 1:steps_l
    tic
    for k = 1:j
        l3 = lgen(j) * lgen(k) / (lgen(j) + lgen(k));
        [dummy, loc] = min(abs(lpump - l3)); %nearest neigbour interpolation 
        for l = 1:steps_w
            %%
            %{
            for m = 1:ngrid^2 
                if XX(2,m) > (-aCore - dead)*1e-6  && XX(1,m) < width(l)*1e-6 / 2
                % points which lie in the reduced chi2 region 
                    int = int + NL_frac * squeeze(sum(conj(egen(:,j) .* egen(:,k)) .* epump(:,loc)));  
                    n1 = n1 + 1;
                else 
                    int = int + squeeze(sum(conj(egen(:,j) .* egen(:,k)) .* epump(:,loc)));  
                    n2 = n2 + 1;
                end
            end
            %}
            mask1 = XX(2,:) > (-aCore - dead)*1e-6  & XX(1,:) < width(l)*1e-6 / 2; % inside proton exchanged area 
            mask2 = XX(2,:) < (-aCore - dead)*1e-6  | XX(1,:) > width(l)*1e-6 / 2; % other region 
            int1 = squeeze(sum(conj(egen(mask1,j) .* egen(mask1,k)) .* epump(mask1,loc))); 
            int2 = squeeze(sum(conj(egen(mask2,j) .* egen(mask2,k)) .* epump(mask2,loc)));
            rho(j,k,l) = NL_frac * int1 + int2; 
            rho(k,j,l) = NL_frac * int1 + int2; % completes symetry 
            %keyboard
        end
    end
    toc / (steps_l * steps_w) %average time to execute inner loop 
    j
end


%% Gathers arrays from gpu

omegas = 2* pi * c / (1.5e-6);  

keyboard
rho = rho * height * wwidth * 1E-12 / ngrid^2; % integrate in S I units 
rho = (rho * epsilon * d33)  / (8. * 2.^0.5);%root two factor takes account of half geometry
rho = gather(rho);
lpump = gather(lpump);
lgen = gather(lgen);
width = gather(width);

t = datetime('now','TimeZone','local','Format','yyMMdd_HHmm'); 
t = char(t);
a = num2str(aCore*1000);
s = strcat('rho_2_neff_aCore=',a,'nm_',t,'(PE_taper)')


%% plots 2d picture 















