% taper ratio 0.2
%-------------------------------------------------------------------------%
% This code is designed to use the data from rho sweep to calculate the
% purity from the joint spectrum for a particular taper profile. Code can
% also calulate the probabilty of generating a photon from a pulse with
% peak power of 1W. 

% For more info email: Philip.Main@bath.ac.uk

% dependancies: profile, taper_calculate2, vis
% note: remember to make ngen into 2d array 


% once rho2 and neff has been calculated all the results can be calculated
% using this script


global nw ng wlgen ngen npump lpump lgen width rho nsweep nratio hbar epsilon c d33



% patch for data set rho_aCore=72_160425_1457 
% uncomment for first run of code 

%
%load 'rho_2_neff_aCore=720nm_161003_1615(PE_taper)'
%{
npump = squeeze(matrepeat(npump, 60));
ngen = squeeze(matrepeat(ngen, 60));
npump = gather(npump);
ngen = gather(ngen); 
width = gather(width);
lgen = gather(lgen);
lpump = gather(lpump);
rho = gather(rho); 
%}

nsweep = 200;
%lgen = gather(lgen);
%lpump = gather(lpump);
wlint = [1.1, 1.8];
ng = 300;
nw = 200; 
wlgen = linspace(wlint(1), wlint(2), ng); 
nratio = 2;
ratio = linspace(1., 1., nratio);% variable being sweept
%ratio = linspace(30, 80, nratio);
%ratio = linspace(1.5e-2, 2e-2, nratio);  
vis_A = zeros(nsweep, nratio); 
A = zeros(ng, ng, nratio);

%%
for k = 1:nratio
    k
    ratio(k)
    %ww = profile(1.); 
    ww = profile(ratio(k));
    %ww = profile3(ratio(k));
    [a, b, id, sig] = taper_calculate2(ww, 1.6e-2);
    %[a, b, id, sig] = taper_calculate2(ww, ratio(k))
    A(:,:,k) = a;
    vis_A(:,k) = b;
    subplot(2,1,1)
    pcolor(abs(A(:,:,k))), shading interp
    subplot(2,1,2)
    plot(squeeze(vis_A(:,1:k)));
    pause(0.001)
    break
end
lamP = linspace(0.66, 0.8, nsweep); 


%% Calculate rate integral 
c = 3.e8
fwhm = 1.6e-2
sigma = fwhm / (2*sqrt(2*log(2))); 



% choose point of choice and recalculate by ...  
lamP = 0.72
sigma_w = 2* pi * c * sigma * 1.e-6 / (lamP * 1.e-6)^2 
[wl1, wl2] = meshgrid(wlgen, wlgen);
[neff1, neff2] = meshgrid(ngen(:,1)', ngen(:,1)'); 
wlint = (wlgen(2) - wlgen(1)).^2  * 1.e-12; 


pump = exp(-(lamP - wl1.*wl2 ./ (wl1 + wl2)).^2 / (2*sigma^2));
wl1 = wl1 * 1.e-6; wl2 = wl2 * 1.e-6;

%
F_int = abs(squeeze(A(:,:,1) .* pump).^2) * 4. * pi^2 * c^2 ./(wl1.^2 .* wl2.^2);
%F_int2 = abs(squeeze(A(:,:,1) .* pump)) * 4. * pi^2 * c^2 ./(wl1.^2 .* wl2.^2);

%calculate integral 0.5 factor comes from filtering 2pi from change of
%variable

psi_prod = sum(sum(F_int)) * wlint * 2*pi / sigma_w^2

%/ Pow_norm
%omega_p = 2*pi*c / (lamP * 1.e-6);  
%PhotonNum = psi_prod^2 / ((hbar * omega_p) / 100.e-15)    
%} 

% the wei way of 




