#include <stdio.h>
#include <stdlib.h>



int main( int argc, char *argv[] )
{
  float homo, delta;
  FILE *fq;

  if (argc!=3) {
    printf("postproc requires two arguments: highest occupied energy, delta value.\n");
    exit(1);
  }

  homo  = atof(argv[1]);
  delta = atof(argv[2]);
  printf("\n");
  printf("Highest occupied state at %f eV\n",homo);
  printf("Energy range %f to %f eV\n",homo-delta, homo+delta);

  fq = fopen("energy_range.txt","w");
  fprintf(fq,"%f\n",homo-delta);
  fprintf(fq,"%f\n",homo+delta);
  fclose(fq);

  return 0;
}
