#!/bin/sh

# run from directory where this script is
cd `echo $0 | sed 's/\(.*\)\/.*/\1/'` # extract pathname
EXAMPLE_DIR=`pwd`

# check whether echo has the -e option
if test "`echo -e`" = "-e" ; then ECHO=echo ; else ECHO="echo -e" ; fi

$ECHO
$ECHO "$EXAMPLE_DIR : starting"
$ECHO
$ECHO "Single layer Rhenium disulphide"

INPUT_PREFIX="ReS2"

# set the needed environment variables (for lbox2 here)
. ../environment_variables

$ECHO
$ECHO "  executables directory: $BIN_DIR"
$ECHO "  pseudo directory:      $PSEUDO_DIR"

	$ECHO "  checking that needed directories and files exist..."

	# check for directories
	for DIR in "$BIN_DIR" "$PSEUDO_DIR" ; do
	if test ! -d $DIR ; then
		$ECHO
		$ECHO "ERROR: $DIR not existent or not a directory"
		$ECHO "Aborting"
		exit 1
	fi
	done

for DIR in "$TMP_DIR" "$EXAMPLE_DIR/results" ; do
if test ! -d $DIR ; then
	mkdir $DIR
fi
done

cp $0 $EXAMPLE_DIR/results
cd $EXAMPLE_DIR/results

# how to run executables
PW_COMMAND="$PARA_PREFIX castep.mpi $PARA_POSTFIX"
$ECHO "  running castep as:       $PW_COMMAND"
$ECHO "  input file prefix is:    $INPUT_PREFIX"
$ECHO

# set up input files
cat > $INPUT_PREFIX.cell << EOF
%BLOCK LATTICE_ABC
6.352	6.446	12.779
91.51	105.1	118.97
%ENDBLOCK LATTICE_ABC
 
%BLOCK POSITIONS_FRAC  ! these should be relaxed
Re	0.0535	0.3095	0.2472
Re	0.4845	0.2882	0.248
Re	0.9381	0.6902	0.2552
Re	0.5084	0.717	0.25
S	0.249	0.383	0.102
S	0.7194	0.3458	0.1204
S	0.2268	0.1139	0.3611
S	0.7546	0.1368	0.3452
S	0.7461	0.6157	0.3878
S	0.271	0.6584	0.3778
S	0.7713	0.8935	0.1372
S	0.2469	0.8669	0.1475
Re	0.9465	0.6905	0.7528
Re	0.5155	0.7118	0.752
Re	0.0619	0.3098	0.7448
Re	0.4916	0.283	0.75
S	0.751	0.617	0.898
S	0.2806	0.6542	0.8796
S	0.7732	0.8861	0.6389
S	0.2454	0.8632	0.6548
S	0.2539	0.3843	0.6122
S	0.729	0.3416	0.6222
S	0.2287	0.1065	0.8628
S	0.7531	0.1331	0.8525
%ENDBLOCK POSITIONS_FRAC
 
%BLOCK SPECIES_POT
Re $PSEUDO_DIR/Re_00.recpot
Se $PSEUDO_DIR/S_00.recpot
%ENDBLOCK SPECIES_POT 

KPOINTS_MP_GRID 6 6 1
KPOINT_MP_OFFSET 0 0 0
 
symmetry_generate  
snap_to_symmetry
EOF

cat > $INPUT_PREFIX.param << EOF
task		   : GEOMETRYOPTIMIZATION 
basis_precision    : fine
metals_method  	   : DM  
#smearing_width    : 0.04 eV  
#nextra_bands      : 4  
#spin_polarized    : false  
 
opt_strategy      : speed  
num_dump_cycles   : 0  
xc_functional     : LDA
#cut_off_energy    : 400

geom_convergence_win 	: 5
geom_force_tol		: 0.05
#geom_disp_tol		: 0.001 ang

max_scf_cycles   	: 100
write_bib		: false
EOF


$ECHO "  running CASTEP..."
$PW_COMMAND $INPUT_PREFIX 
$ECHO " done"

$ECHO
$ECHO "$EXAMPLE_DIR: done"

grep 'Final energy' *.castep > energies.dat


