function [P,Q,cumsum_P,cumsum_P_pos,Q_rates] = ZRPcreateP2dClosed(L,V,c)

    B = zeros(L);
    for i = 1:L
        if(i < mod(i+1,L)+L*(mod(i+1,L)==0))
        	B(i,mod(i+1,L)+L*(mod(i+1,L)==0)) = 1;
        end
        if(i > mod(i-1,L)+L*(mod(i-1,L)==0))
        	B(i,mod(i-1,L)+L*(mod(i-1,L)==0)) = 1;
        end
    end
    P = zeros(L^2);

    for i = 1:L
    	P((i-1)*L+1:(i-1)*L+L,(i-1)*L+1:(i-1)*L+L) = B;
    end

    for i = 1:L-1
    	P(i*L+1:(i)*L+L,(i-1)*L+1:(i-1)*L+L) = eye(L);
    	P((i-1)*L+1:(i-1)*L+L,i*L+1:i*L+L) = eye(L);
    end
        
    for i = 1:L
       P((i-1)*L+1,(i-1)*L+3) = 0;
       P(i*L,i*L-2) = 0;
    end
    
    P = P./4;
    
    P_rates = zeros(1,L^2);
    for i = 1:L^2
        P_rates(i) = sum(P(i,:));
    %    P(i,i) = 1-P_rates(i);
    end
    
    VV = reshape(V,L,L)';

    V1p = circshift(VV,[0 -1]); % V(x+e1)
    V1m = circshift(VV,[0 1]); % V(x-e1)
    V2p = circshift(VV,[1 0]); % V(x+e2)
    V2m = circshift(VV,[-1 0]); % V(x-e2)

    V12p = circshift(VV,[1 -1]); % V(x+e1+e2)

    W = exp(-(VV + V1p + V2p + V12p)./4); 

    Wn = W - circshift(W,[0 1]); % W(x) - W(x-e1)
    We = circshift(W,[-1 0]) - W; % W(x-e2) - W(x)
    Ws = circshift(W,[-1 1]) - circshift(W,[-1 0]); % W(x-e1-e2) - W(x-e2)
    Ww = circshift(W,[0 1]) - circshift(W,[-1 1]); % W(x-e1) - W(x-e1-e2)

    %%%%%%%%%%%%%%%%%
    Wn = reshape(Wn',1,L^2);
    We = reshape(We',1,L^2);
    Ws = reshape(Ws',1,L^2);
    Ww = reshape(Ww',1,L^2);

    V = reshape(VV',1,L^2);
    V1p = reshape(V1p',1,L^2); % V(x+e1)
    V1m = reshape(V1m',1,L^2); % V(x-e1)
    V2p = reshape(V2p',1,L^2); % V(x+e2)
    V2m = reshape(V2m',1,L^2); % V(x-e2)

        
    Q = P>0;
        
    for i = 1:L^2
        % p(x,x+e2)
    	P(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0)) = ...
          P(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0))*exp((V(i)-V2p(i))/2);
      
    	% p(x,x+e1)  
    	P(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0)) = ...
          P(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0))*exp((V(i)-V1p(i))/2);

    	% p(x,x-e2)
    	P(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0)) = ...
          P(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0))*exp((V(i)-V2m(i))/2);
      
    	% p(x,x-e1)
    	P(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0)) = ...
          P(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0))*exp((V(i)-V1m(i))/2);
    end
    
    K = zeros(size(P));
    K_pos = zeros(size(P));
    
    for i = 1:L^2
        % p(x,x+e2)
    	K(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0)) = ...
          Q(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0))*(c(2)/10 + c(3)*Wn(i));
      
    	% p(x,x+e1)  
    	K(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0)) = ...
          Q(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0))*(c(1)/10 + c(3)*We(i));

    	% p(x,x-e2)
    	K(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0)) = ...
          Q(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0))*(-c(2)/10 + c(3)*Ws(i));
      
    	% p(x,x-e1)
    	K(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0)) = ...
          Q(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0))*(-c(1)/10 + c(3)*Ww(i));
    end
    
    K(1,2) = 0;
    K(2,1) = -K(1,2);
    K_pos(1,2) = 1;
    K_pos(2,1) = 1;
    for j = 2:(L-1)
        K(j,j+1) = K(j+L,j) + K(j-1,j);
        K(j+1,j) = -K(j,j+1);
        K_pos(j,j+1) = 1;
        K_pos(j+1,j) = 1;
    end
    K(L,2*L) = K(L-1,L);
    K(2*L,L) = -K(L,2*L);
    K_pos(L,2*L) = 1;
    K_pos(2*L,L) = 1;
    for j = 2:(L-1)
        K(j*L,(j+1)*L) = K((j-1)*L,j*L) + K(j*L-1,j*L);
        K((j+1)*L,j*L) = -K(j*L,(j+1)*L);
        K_pos(j*L,(j+1)*L) = 1;
        K_pos((j+1)*L,j*L) = 1;
    end
    K(L^2,L^2-1) = K(L^2-L,L^2);
    K(L^2-1,L^2) = -K(L^2,L^2-1);
    K_pos(L^2,L^2-1) = 1;
    K_pos(L^2-1,L^2) = 1;
    for j = 2:(L-1)
        K(L^2-j+1,L^2-j) = K(L^2-L-j+1,L^2-j+1) + K(L^2-j+2,L^2-j+1);
        K(L^2-j,L^2-j+1) = -K(L^2-j+1,L^2-j);
        K_pos(L^2-j+1,L^2-j) = 1;
        K_pos(L^2-j,L^2-j+1) = 1;
    end
    K(L^2-L+1,L^2-2*L+1) = K(L^2-L+2,L^2-L+1);
    K(L^2-2*L+1,L^2-L+1) = -K(L^2-L+1,L^2-2*L+1);
    K_pos(L^2-L+1,L^2-2*L+1) = 1;
    K_pos(L^2-2*L+1,L^2-L+1) = 1;
    for j = 2:(L-1)
        K(L^2-L*j+1,L^2-L*(j+1)+1) = K(L^2-L*(j-1)+1,L^2-L*j+1) + K(L^2-L*j+2,L^2-L*j+1);
        K(L^2-L*(j+1)+1,L^2-L*j+1) = -K(L^2-L*j+1,L^2-L*(j+1)+1);
        K_pos(L^2-L*j+1,L^2-L*(j+1)+1) = 1;
        K_pos(L^2-L*(j+1)+1,L^2-L*j+1) = 1;
    end
        
    for i = 1:L^2
          % p(x,x+e2)
    	K(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0)) = K(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0))*exp(V(i));
          % p(x,x+e1)  
    	K(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0)) = K(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0))*exp(V(i));
          % p(x,x-e2)
    	K(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0)) = K(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0))*exp(V(i));
          % p(x,x-e1)
    	K(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0)) = K(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0))*exp(V(i));
    end
    
    P = P+K;
    Q = P;
    Q_rates = zeros(1,L^2);
        
    if(nnz(Q<0)>0)
        disp('Q contains negative values on the off diagonals!')
    end
          
    for i = 1:L^2
    	Q_rates(i) = sum(Q(i,:));   % outward jump rates away from i
        Q(i,i) = Q(i,i)-Q_rates(i); % finish construction of Markov chain Q-matrix
    	P(i,:) = P(i,:)/sum(P(i,:)); % normalise jump rates -> P is now a stochastic matrix
    end

    cumsum_P = zeros(L^2,4);
    cumsum_P_pos = zeros(L^2,4);
    
    for i = 1:L^2
        cumsum_P_pos(i,1:nnz(P(i,:)>0)) = find(P(i,:)>0);
        cumsum_P(i,1:nnz(P(i,:)>0)) = cumsum(P(i,P(i,:)>0)); % create cumulative sum of jump rates (for Gillespie algorithm).
    end
    
    if(nnz(P<0)>0)
        disp('P contains negative values!')
    end
end