clear

L = 140;

VV = zeros(L,L);
a=2;
for i = 1:L
    for j = 1:L
        VV(i,j) = 500*((j/L-0.5)^2-0.085)^2 + 30*(i/L -1/2)^2+2.5*(j/L-1/2);
    end
end

VV = min(5,VV);
V = reshape(VV',1,L^2);

lambda = 0.25; % factor for initial number of particles

n_sample = 16; % number of samples for average.

t = (1:1:200)*0.1*lambda*L^2/2; 

c = [0 0 0.4]; % drift term

domain = 'non-torus';

parpool('local', 16);

runZRP(L,V,c,n_sample,t,lambda,'zrp_2d_ndb_superlinear.mat',1,domain)