function [eta_store] = simulateZRP(L,V,c,n_sample,t,lambda,domain)
    if (strcmp(domain,'torus'))
        [~,~,cumsum_P,cumsum_P_pos,Q_rates] = ZRPcreateP2D(L,V,c);
    else
        [~,~,cumsum_P,cumsum_P_pos,Q_rates] = ZRPcreateP2dClosed(L,V,c);
    end
         
    eta_store = zeros(length(t),L^2);
    
    display('Number of sample paths for simulation:')
    display(n_sample)
    display('Starting simulation!')
    tic_run = tic();
    parfor l = 1:n_sample

        eta = zeros(1,L^2);
        eta(floor(L^2/2-L/4)) = 2*lambda*L^2;
        
        cumsum_jumprate = zeros(ceil(2*log(L)/log(2))+1,L^2);
        cumsum_jumprate(1,:) = ZRPg(eta).*Q_rates;
        for k = 2:ceil(2*log(L)/log(2))+1
            for j = 1:ceil(L^2/2^(k-1))
                cumsum_jumprate(k,j) = cumsum_jumprate(k-1,2*j-1) + cumsum_jumprate(k-1,2*j);
            end
        end
        
        eta_store_temp = zeros(length(t),L^2);

        t_now = 0;

        for i = 1:length(t)            
            while(t_now < t(i))
                t_now = t_now + exprnd(1./cumsum_jumprate(end,1));
                [eta,cumsum_jumprate] = ZRPupdateWrapper(eta,cumsum_jumprate,cumsum_P,cumsum_P_pos,Q_rates);
            end
            eta_store_temp(i,:) = eta;
        end
    
        eta_store = eta_store + eta_store_temp;
       
    end
    t_end = toc(tic_run);
    display('Simulation finished, Time needed in seconds:')
    display(t_end)
    
    eta_store = eta_store/n_sample;

end
