clear

L = 300;

V = zeros(1,L);
for i = 1:L
      V(i) = 3/2*(sin(4*pi*i/L)-cos(2*pi*i/L)/2);
end

t = (1:200)*L^2/200;
n_sample = 20000;


c = 180/L;
[P,Q,cumsum_P,cumsum_P_pos,Q_rates] = ZRPcreateP1D(L,V,c);


parpool('local', 16);

[eta_0, Veta0] = simulateZRP1D(L,V,0,n_sample,t);

[eta_1, Veta1] = simulateZRP1D(L,V,c,n_sample,t);

save('simulation_300');
