function [P,Q,cumsum_P,cumsum_P_pos,Q_rates] = ZRPcreateP1D(L,V,c)

    P = zeros(L);
    for i = 1:L
    	P(i,mod(i+1,L)+L*(mod(i+1,L)==0)) = 1;
    	P(i,mod(i-1,L)+L*(mod(i-1,L)==0)) = 1;
    end

    P = P./4;

   

    V1p = circshift(V,[0 -1]); % V(x+e1)
    V1m = circshift(V,[0 1]); % V(x-e1)


%     W = exp(-(V + V1p)./2); 
% 
%     Wn = W - circshift(W,[0 1]); % W(x) - W(x-e1)
%     We = circshift(W,[-1 0]) - W; % W(x-e2) - W(x)
%     Ws = circshift(W,[-1 1]) - circshift(W,[-1 0]); % W(x-e1-e2) - W(x-e2)
%     Ww = circshift(W,[0 1]) - circshift(W,[-1 1]); % W(x-e1) - W(x-e1-e2)

%     %%%%%%%%%%%%%%%%%
%     Wn = reshape(Wn',1,L^2);
%     We = reshape(We',1,L^2);
%     Ws = reshape(Ws',1,L^2);
%     Ww = reshape(Ww',1,L^2);
% 
%     V = reshape(VV',1,L^2);
%     V1p = reshape(V1p',1,L^2); % V(x+e1)
%     V1m = reshape(V1m',1,L^2); % V(x-e1)
%     V2p = reshape(V2p',1,L^2); % V(x+e2)
%     V2m = reshape(V2m',1,L^2); % V(x-e2)


    for i = 1:L
    	% p(x,x+e1)  
    	P(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0)) = ...
          P(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0))*(exp((V(i)-V1p(i))/2) + c/10*exp(V(i)));

    	% p(x,x-e1)
    	P(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0)) = ...
          P(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0))*(exp((V(i)-V1m(i))/2) - c/10*exp(V(i))); 
    end 

    Q = P;
    Q_rates = zeros(1,L);
        
    for i = 1:L
    	Q_rates(i) = sum(Q(i,:));   % outward jump rates away from i
    	P(i,:) = P(i,:)/Q_rates(i); % normalise jump rates -> P is now a stochastic matrix
        Q(i,i) = Q(i,i)-Q_rates(i); % finish construction of Markov chain Q-matrix
    end

    cumsum_P = zeros(L,2);
    cumsum_P_pos = zeros(L,2);
    
    for i = 1:L
        cumsum_P_pos(i,:) = find(P(i,:)>0);
    	cumsum_P(i,:) = cumsum(P(i,P(i,:)>0)); % create cumulative sum of jump rates (for Gillespie algorithm).
    end
       
    if(size(P(P<0)) ~= [0 0])
        disp('P contains negative values!')
    end
end

