function [P,Q,cumsum_P,cumsum_P_pos,Q_rates] = ZRPcreateP2D(L,V,c)

    B = zeros(L);
    for i = 1:L
    	B(i,mod(i+1,L)+L*(mod(i+1,L)==0)) = 1;
    	B(i,mod(i-1,L)+L*(mod(i-1,L)==0)) = 1;
    end

    P = zeros(L^2);

    for i = 1:L
    	P((i-1)*L+1:(i-1)*L+L,(i-1)*L+1:(i-1)*L+L) = B;
    end

    for i = 1:L-1
    	P(i*L+1:(i)*L+L,(i-1)*L+1:(i-1)*L+L) = eye(L);
    	P((i-1)*L+1:(i-1)*L+L,i*L+1:i*L+L) = eye(L);
    end
    
    P((L-1)*L+1:L*L,1:L) = eye(L);
    P(1:L,(L-1)*L+1:L*L) = eye(L);

    P = P./4;

    VV = reshape(V,L,L)';

    V1p = circshift(VV,[0 -1]); % V(x+e1)
    V1m = circshift(VV,[0 1]); % V(x-e1)
    V2p = circshift(VV,[1 0]); % V(x+e2)
    V2m = circshift(VV,[-1 0]); % V(x-e2)

    V12p = circshift(VV,[1 -1]); % V(x+e1+e2)

    W = exp(-(VV + V1p + V2p + V12p)./4); 

    Wn = W - circshift(W,[0 1]); % W(x) - W(x-e1) = k(x,x+e2)
    We = circshift(W,[-1 0]) - W; % W(x-e2) - W(x) = k(x,x+e1)
    Ws = circshift(W,[-1 1]) - circshift(W,[-1 0]); % W(x-e1-e2) - W(x-e2) = k(x,x-e2)
    Ww = circshift(W,[0 1]) - circshift(W,[-1 1]); % W(x-e1) - W(x-e1-e2) = k(x,x-e1)

    %%%%%%%%%%%%%%%%%
    Wn = reshape(Wn',1,L^2);
    We = reshape(We',1,L^2);
    Ws = reshape(Ws',1,L^2);
    Ww = reshape(Ww',1,L^2);

    V = reshape(VV',1,L^2);
    V1p = reshape(V1p',1,L^2); % V(x+e1)
    V1m = reshape(V1m',1,L^2); % V(x-e1)
    V2p = reshape(V2p',1,L^2); % V(x+e2)
    V2m = reshape(V2m',1,L^2); % V(x-e2)

    for i = 1:L^2
     % p(x,x+e2)
     P(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0)) = ...
        P(i,mod(i-L,L^2)+L^2*(mod(i-L,L^2)==0))*(exp((V(i)-V2p(i))/2) + (c(2)/10 + c(3)*Wn(i))*exp(V(i)));
      
     % p(x,x+e1)  
     P(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0)) = ...
        P(i,L*(ceil(i/L)-1)+mod(i+1,L)+L*(mod(i+1,L)==0))*(exp((V(i)-V1p(i))/2) + (c(1)/10 + c(3)*We(i))*exp(V(i)));

     % p(x,x-e2)
     P(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0)) = ...
        P(i,mod(i+L,L^2)+L^2*(mod(i+L,L^2)==0))*(exp((V(i)-V2m(i))/2) + (-c(2)/10 + c(3)*Ws(i))*exp(V(i)));
      
     % p(x,x-e1)
     P(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0)) = ...
        P(i,L*(ceil(i/L)-1)+mod(i-1,L)+L*(mod(i-1,L)==0))*(exp((V(i)-V1m(i))/2) + (-c(1)/10 + c(3)*Ww(i))*exp(V(i))); 
    end 

    Q = P;
    Q_rates = zeros(1,L^2);
        
    for i = 1:L^2
    	Q_rates(i) = sum(P(i,:));   % outward jump rates away from i
    	P(i,:) = P(i,:)/Q_rates(i); % normalise jump rates -> P is now a stochastic matrix
        Q(i,i) = Q(i,i)-Q_rates(i); % finish construction of Markov chain Q-matrix
    end

    cumsum_P = zeros(L^2,4);
    cumsum_P_pos = zeros(L^2,4);
    
    for i = 1:L^2
        cumsum_P_pos(i,:) = find(P(i,:)>0);
    	cumsum_P(i,:) = cumsum(P(i,P(i,:)>0)); % create cumulative sum of jump rates (for Gillespie algorithm).
    end
    if(nnz(P<0)>0)
        disp('P contains negative values!')
    end
end









