# Supporting data for Sparse Cyclis Excitations Explain the Low Ionic Conductivity of Stoichiometric Li<sub>7</sub>La<sub>3</sub>Zr<sub>2</sub>O<sub>12</sub>

This Jupyter notebook, and the accompanying data, constitute supporting data for &ldquo;Sparse Cyclic Excitations Explain the Low Ionic Conductivity of Stoichiometric Li<sub>7</sub>La<sub>3</sub>Zr<sub>2</sub>O<sub>12</sub>&rdquo;, [Burbano et al. *Phys. Rev. Lett.* **116** 135901 (2016)](https://doi.org/10.1103/PhysRevLett.116.135901).  

This dataset reproduces the steps taken in order to generate Figure S3 (d) in the &ldquo;Validation of the Interatomic Potential&rdquo; section of the Supplemental Information for this article. We present four data sets derived from simulations carried out in this work. These are distinguished by the following particles present in the variable names:

1. `a_t_LLZO_eq` : corresponds to simulations of LLZO using the volume obtained from cells equilibrated using an anisotropic barostat and the DIPPIM potential.

2. `i_c_LLZO_eq` : corresponds to simulations of LLZO using the volume obtained from cells equilibrated using an isotropic barostat  and the DIPPIM potential for a system where a cubic symmetry was imposed.

3. `i_c_LLZO_0K` : corresponds to simulations of LLZO using the volume obtained by optimizing the cell using a conjugate gradients algorithm and the DIPPIM potential for a system of cubic symmetry.

4. `i_c_LLZO_0K_Jalem` : corresponds to simulations using the DIPPIM potential and the volume from [Jalem *et al.* *Chem. Mater.* 2013](https://dx.doi.org/10.1021/cm303542x).

Additionally, we have used from *ab-initio* Molecular Dynamics (AIMD) simulations carried out by [Jalem et al. Chem. Mater 2013](https://dx.doi.org/10.1021/cm303542x) and [Miara et al. Chem. Mater. 2013](https://dx.doi.org/10.1021/cm401232r). The values extracted from these articles were digitized from figures presented in the original publications. Further details pertaining their extraction and the transformations applied to the raw data are delineated in the notebook. In short, transformations were only applied to the Miara *et al.* data to convert the original Nernst-Einstein conductivities into diffusion coefficients. 

The final result obtained from this notebook is a figure that puts the DIPPIM results into the context of existing AIMD results. The values presented are the diffusion coefficients from our work and the literature. 

If you make use of these data, please cite the doi [https://doi.org/10.15125/BATH-00366](https://doi.org/10.15125/BATH-00366).  
If you make use of the Jalem or Miara data sets, please cite the respective original publications.

To run the Jupyter notebook, the packages listed in `requirements.txt` should be installed, e.g. via
```
pip install -r requirements.txt
```

The authors, 

17/5/17
