#include <random>
#include <stdio.h>
#include <mpi.h>

using namespace std;

class latticepack
{
public:
        latticepack(vector<int> dim);
        ~latticepack();
        void pack(lattice* lat, char *buff, int *position, int size);
        void unpack(lattice *lat, char *recbuff, int *position, int size);
        int N, L; //Size in bytes of one lattice
};

latticepack::latticepack(vector<int> dim) {
	N = dim[1];
	L = dim[0];
}
	
void latticepack::pack(lattice *lat, char *buff, int *position, int size){
  MPI_Pack(lat->p.data(), N, MPI_INT, buff, size, position, MPI_COMM_WORLD); //Pack Particle Positions
  MPI_Pack(lat->s.data(), L, MPI_INT, buff, size, position, MPI_COMM_WORLD); //Pack Site Occupancies
  MPI_Pack(lat->freedom.data(), N, MPI_INT, buff, size, position, MPI_COMM_WORLD); //Pack Particle Freedoms
  MPI_Pack(&lat->esc, 1, MPI_DOUBLE, buff, size, position, MPI_COMM_WORLD); //Pack Escape Rate
}

void latticepack::unpack(lattice *lat, char *recbuff, int *position, int size){
  MPI_Unpack(recbuff, size, position, lat->p.data(), N, MPI_INT, MPI_COMM_WORLD); //Unpack Particle Position
  MPI_Unpack(recbuff, size, position, lat->s.data(), L, MPI_INT, MPI_COMM_WORLD); //Unpack Site Occupancies
  MPI_Unpack(recbuff, size, position, lat->freedom.data(), N, MPI_INT, MPI_COMM_WORLD); //Unpack Particle Freedoms
  MPI_Unpack(recbuff, size, position, &lat->esc, 1, MPI_DOUBLE, MPI_COMM_WORLD); //Unpack Escape Rate
}

latticepack::~latticepack(){ /*Destructor*/
}
