##Cloning Algorithm for computing the Large Deviations Function. 



Can be run on any system/process. 
Includes code for SSEP/ASEP/CP on 1-D lattice.


Implements code in OpenMP and MPI including various amount of packing and reduced communication.








####System Requirements


intel/mpi


intel/compiler







####Codes

These are our implementations for running the cloning algorithm.


- Serial: serialcloning.cpp

- OpenMP: cloning.cpp


- MPI:
	
- System Packing: SysPack.cpp
	
- Reduced Communications: LessComms.cpp




##Codes for 1-D lattice 


This folder contains header files for processes to be run on a 1-D lattice.


- latclass.hpp contains the components of a 1-D lattice to be copied during the cloning process

- latinfo.hpp contains all the other functions and variables of interest associated with a 1-D lattice

- latpack.hpp contains MPI functions to pack and unpack the lattice components



Similar header files can be defined for other systems.


This must include the following two header files. 

	
1. A header file which defines the system.
	
		- This header file must include a class that defines the components of the systems to be copied during the cloning process.
	
		- The class must have a constructor which takes a vector of dimensions at its input.
	

2. A header file which defines attributes associated with the system
	
		- The class must have a constructor that takes as an input (in this order):

			- A vector of dimensions

			- The bias s

			- The observable of interest (being biased)

			- The process that evolves the system

			- A vector of process rates
	
		- A pointer to an instance of a mersenne twister (mt19937)
        
			- An initialiser (function called 'init') which takes a pointer to an instance of the system as input. The instance that's pointed to is the system that gets initialised.
	
			- A pointer function (called 'dynamics') which takes a double and a pointer to an instance of the system as an input. The dynamics are run on the instance of the system that's pointed to for an number of units of time equal to the vale of the double.
	
		- A pointer function (called 'calcups') which takes a pointer to a double as an input. This calculates and sets the value of the double equal to the cloning factor.
	
			- Functions that the pointer functions point to to calculate the cloning factor (which will depend on the process and observable) and to run the dynamics (which will also depend on the process). 
	
		- Can also include functions such as:
		
			- Any random number functions called by the process or cloning factor calculation function.
	        
			- Any random number distributions called by the process or cloning factor calculation function.
	        
			- Boundary condition functions
	
	        - Consistency checker functions
	
	        - Size in bytes that can be used in some MPI implementations
	        
			- Any other variables that may be used when running the process or during the cloning factor calculation




####Makefile

The makefile includes makes for the four implementations (stated above) included in this data package.

At the top of the makefile (by default) it assumes that the system being run is a 1-D lattice and so the makefile includes the corresponding header files (latclass.hpp and latinfo.hpp). 

If the user uses alternative systems or processes then these can be used by this makefile (and these implementations) by inserting their corresponding (.hpp) header files to the appropriate place in the makefile (i.e. system= and info=). 






####Authors 
(All University of Bath)


- Tobias Brewer (T.J.M.Brewer@bath.ac.uk)


- Robert Jack


- Russell Bradford


- Stephen Clarke


####Additional Codes
Some variations of the codes are required to produce the exact results in this data set.
	- Figure 2: Trajectories:
		- A code that runs cloning.cpp and prints where each clone is copied to
		- A code that then traces a path back through of the index of the system that ends up being copied to index 0.
		- A code that runs cloning.cpp and prints out the site occupancy of the system at each step along this path.
	- Figure 3 & 8: Fourier Component of Density & Averages of Observables:
		- A code that runs cloning.cpp and prints out the average of observables at different orders of magnitude of units of time.
	- Figure 4, 6, 7 & 10: Psi, Activity, Susceptibility, Tau Errors, Time Convergence & Clone Convergence
		- Codes that runs cloning.cpp and print out the average activity, activity variance and average of activity squared across the simulation.
	- Figure 9: AutoCorrelation
		- A code that runs cloning.cpp and prints out the autocorrelation relative to two values of units of time. 
		  One of the values of units of time is at various orders of magnitude.
	- Figure 11: Probability Distributions
		- A code that runs cloning.cpp and prints out the value of an obervable associated with each sytem.
	- Figure 14: Communications Patterns
                - Codes that run to corresponding MPI implementations and print out their communication patterns.