#include <stdio.h>
#include <binarysearch.hpp>

template<class SystemInfo>
void csm1serial(int* c, double* key, int nc, double totups, SystemInfo *iclass, int arrswitch)
{
  double r;
  int i;
  for(i=0; i<nc; i++)
  {
    r = (iclass[(1-arrswitch)*nc + i]->randc())*totups; //Generate a random number from 0 to the total of upsilon
    c[i] = binsearch(key, r, nc + 1); //Use this random number to select a system to clone
  }
}

template<class SystemInfo>
void csm2serial(int* c, double* key, int nc, double totups, SystemInfo *iclass, int arrswitch)
{
  double r;
  int i;
  double rc = (iclass[(1-arrswitch)*nc]->randc())*totups/double(nc);
  for(i=0; i<nc; i++)
  {
    r = rc+(double(i)*totups/double(nc)); //Place markers at regular intervals
    c[i] = binsearch(key, r, nc + 1); //Use these markers to select systems to clone
  }
}
