#include <stdio.h>

#include <vector>



using namespace std;



class lattice

{

public:

  lattice(vector<int> dim); /*Declare Constructor*/

  ~lattice(); /*Declare Destructor*/

  std::vector<int> p; /*Holds position of each particle*/

  std::vector<int> s; /*States which particle is in each site*/

  std::vector<int> freedom; /*Holds freedom of each particle*/

  double esc; /*Holds escape rate*/

};



lattice::lattice(vector<int> dim) { /*Constructor*/

  int k, csite, lsite, rsite, neighbours;

  int new_L = dim[0];

  int new_N = dim[1];

  s.clear(); /*Make sure lattice empty before initializing*/

  p.clear();

  freedom.clear();

  for(k=0; k<new_L; k++)

  {

    (s).push_back(-1); /*Set each site as empty*/

    if(k<new_N)

    {

      p.push_back(-1); /*Set each particle as not yet having a position*/

      freedom.push_back(2); /*Set the freedom as unknown*/

    }

  }

}



lattice::~lattice(){ /*Destructor*/

  p.clear();

  p.shrink_to_fit();

  s.clear();

  s.shrink_to_fit();

  freedom.clear();

  freedom.shrink_to_fit();

}

