#include <random>
#include <stdio.h>
#include <mpi.h>

using namespace std;

class latcompsend
{
public:
        latcompsend(vector<int> dim);
        ~latcompsend();
        void compsend(lattice* lat, int procsend);
        void comprecv(lattice* lat, int procrecv);
        int N, L; //System dimensions
};

latcompsend::latcompsend(vector<int> dim) {
        N = dim[1]; //Number of Particles
        L = dim[0]; //Number of Sites
}
	
void latcompsend::compsend(lattice *lat, int procsend){
  MPI_Send(lat->p.data(), N, MPI_INT, procsend, 1, MPI_COMM_WORLD); //Send Particle Positions
  MPI_Send(lat->s.data(), L, MPI_INT, procsend, 1, MPI_COMM_WORLD); //Send Site Occupancies
  MPI_Send(lat->freedom.data(), N, MPI_INT, procsend, 1, MPI_COMM_WORLD); //Send Particle Freedoms
  MPI_Send(&lat->esc, 1, MPI_DOUBLE, procsend, 1, MPI_COMM_WORLD); //Send Escape Rate
}

void latcompsend::comprecv(lattice *lat, int procsend){
  MPI_Recv(lat->p.data(), N, MPI_INT, procsend, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE); //Receive Particle Position
  MPI_Recv(lat->s.data(), L, MPI_INT, procsend, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE); //Receive Site Occupancies
  MPI_Recv(lat->p.data(), N, MPI_INT, procsend, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE); //Receive Particle Freedoms
  MPI_Recv(&lat->esc, 1, MPI_DOUBLE, procsend, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE); //Receive Escape Rate
}

latcompsend::~latcompsend(){ /*Destructor*/
}
