function apparent_freq=gFA(yiq,fs,method)
%GFA Compute phase rate of change (apparent frequency) in Hz
if method==1
ry=real(yiq); iy=imag(yiq); gry=gradient(ry); giy=gradient(iy);
apparent_freq = ((ry.*giy-iy.*gry)./(ry.^2+iy.^2));
else
% equivalent method
apparent_freq = gradient(unwrap(angle(yiq)));
end
apparent_freq=apparent_freq*fs/2/pi;