clear; load('koh_et_al_2017_RadioScience.mat');                          % load processed array data

% define parameters
fs=1e6; datL=6;                                                             % sampling frequency and data length

fb=1.5*1e2;                                                                 % half filter bandwidth
fc=23.4e3;                                                                  % DHO centre frequency
sbL=5e-3;                                                                   % symbol length
sps=sbL*fs;

sft=3e-2;                                                                   % sferic detection amplitude threshold
nS=6e3;                                                                     % number of samples to discard around sferic

res=1e3;                                                                    % rough data resolution
srs=1e6;                                                                    % statistics resolution
ntn=8e3;                                                                    % number of samples to discard around transition in samples
npfl=10;                                                                    % number of symbol lengths to remove at edges to mitigate filter edge effects
binW=pi/2399; eLH=[-pi pi]; binWA=5e-6; eLHA=[3e-4 7.5e-4];                 % histogram parameters

% initialise
n=2*datL*fs; nf=2^nextpow2(2*n-1);                                          % number of points in frequency domain
f=linspace(0,nf-1,nf)*fs/nf;                                                % frequency vector
flw=fc-fb; fup=fc+fb;                                                       % box filter parameters
id=f<flw|f>fup; idM=f<(fs-fb)&f>fb;                                         %

pfl=sps*npfl;                            % parameters to mitigate filter edge effects

nr=n/2/srs;                                                                 % statistics resolution in samples
nBins=(eLH(2)-eLH(1))/binW; ed=linspace(eLH(1),eLH(2),nBins+1);             % phase deviation histogram parameters
ctr=ed(1:end-1)+binW/2;                                                     %
nBinsA=(eLHA(2)-eLHA(1))/binWA; edA=linspace(eLHA(1),eLHA(2),nBinsA+1);     % amplitude histogram parameters
ctrA=edA(1:end-1)+binWA/2;                                                  %

% itn=estTn(y,sps);                                                         % estimate bit transition sample
itn=4850;                                                                   % fix the bit transition sample
[symc{1}]=dGMSK(y,sps,itn);                                                 % demodulate

[afM,yM]=mGMSK(fs,sbL,npfl,symc,1,itn);                                     % produce model vector using the lag value of the 1st chunk
YM=fft(yM,nf); YM(idM,:)=0; yM=ifft(YM); yM=yM(1:length(y));                % filter

y=y(pfl+1:end-pfl);                                                         % account for filter edge effects
yMr=reshape(yM(pfl+1:end-pfl),srs,[]); yr=reshape(y,srs,[]);                % split data into chunks of srs samples
afMr=reshape(afM(pfl+1:end-pfl),srs,[]);                                    %

erP=mean(nanmean(abs(angle(yr./yMr))));                                     % error phase
if erP>3*pi/4                                                               % in case the phase deviation is near +/- pi
    yr=yr.*exp(-1j*pi); pos=mean(nanmean(angle(yr./yMr)));                  % shift by pi first
    yr=yr.*exp(-1j*pos); pos=pos+pi;                                        % shift signal phase so phase deviation mean is zero and save offset
else
    pos=mean(nanmean(angle(yr./yMr))); yr=yr.*exp(-1j*pos);                 % otherwise, straightforward offset
end

[bH,bL,idtn]=gsep2(afMr,yMr,ntn);                                           % split data
hp=zeros(length(ctr),2); ha=zeros(length(ctrA),2);
pSD=zeros(nr,2); pM=zeros(nr,2);                                            %
aSD=zeros(nr,2); aM=zeros(nr,2);                                            %
for ij=1:nr                                                                 % statistical analysis per sub chunk
    yy=yMr(:,ij); yMH=yy(bH(:,ij)); yML=yy(bL(:,ij));                       % distinguish for each transmission frequency/phase
    yy=yr(:,ij); ybH=yy(bH(:,ij)); ybL=yy(bL(:,ij));                        %
    
    hp(:,1)=histcounts((angle(ybH./yMH)),ed);                               % phase deviation distributions
    hp(:,2)=histcounts((angle(ybL./yML)),ed);                               %
    
    ha(:,1)=histcounts(abs(ybH),edA);                                       % amplitude distributions
    ha(:,2)=histcounts(abs(ybL),edA);                                       %
    
    [mp,iip]=max(hp); [ma,iia]=max(ha);                                     % distribution max and bin
    NN=[length(ybH) length(ybL)];
    mp=mp./(NN.*binW); ma=ma./(NN.*binWA);                                  % scale distribution maximums
    
    pM(ij,:)=ctr(iip); aM(ij,:)=ctrA(iia);                                  % get distribution modes
    pSD(ij,:)=1/sqrt(2*pi)./mp; aSD(ij,:)=1/sqrt(2*pi)./ma;                 % compute standard deviations from maximums
    
	if ij==2                                                                % for distribution plot only
	    binWp=pi/239;                                                       % bin width (plotting only)
		nBinsp=(eLH(2)-eLH(1))/binWp; edp=linspace(eLH(1),eLH(2),nBinsp+1); % histogram parameters
        ctrp=edp(1:end-1)+binWp/2; hpp=zeros(length(ctrp),2);
		hpp(:,1)=histcounts((angle(ybH./yMH)),edp);                         % phase disturbance distribution
        hpp(:,2)=histcounts((angle(ybL./yML)),edp);                         % 
		NN2=NN;
        hpp=bsxfun(@rdivide,hpp,NN*binWp);                                    % scale distributions
        ha=bsxfun(@rdivide,ha,NN*binWA);                                    %
		
        [mp,iip]=max(hpp); pMp=ctrp(iip); pSDp=1/sqrt(2*pi)./mp;             % distribution max and bin
		
        gp=bsxfun(@minus,repmat(ctrp',1,2),pMp);                            % Gaussian distribution fit with max at mode
        gp=bsxfun(@rdivide,(gp.^2)/2,pSDp.^2);                              %
		gp=bsxfun(@times,mp,exp(-gp));                                      %
        ga=bsxfun(@minus,repmat(ctrA',1,2),aM(ij,:));                       %
        ga=bsxfun(@rdivide,(ga.^2)/2,aSD(ij,:).^2);                         %
		ga=bsxfun(@times,ma,exp(-ga));                                      %
        
        f5l=figure('Color','w'); plot(ctrA*1e3,ha*binWA*100); grid on;      % plot amplitude distributions
        hold on; plot(ctrA*1e3,ga*binWA*100,'--'); hold off
        xlabel('|y_r| (mVm^{-1})'); ylabel('%'); ax=gca; ax.FontSize=14;
		xlim([.46 .62]); ax.XTick=.46:.02:.62;
		ax.YTick=0:2:14;
		f5l.Units='centimeters'; f5l.Position=[35 1.5 15 12];
		%export_fig f5l.png -r300
		
        f5r=figure('Color','w'); plot(ctrp,hpp*binWp*100); grid on;         % plot phase disturbance distributions
        hold on; plot(ctrp,gp*binWp*100,'--'); hold off
        xlabel(['\phi_d ' sprintf('(%c)', char(176))]);
        ylabel('%'); ax=gca; ax.FontSize=14;
		xlim([-1 1]*.1); ax.XTick=-.1:.05:.1; ax.XMinorGrid='on';
		ylim([0 42]); ax.YTick=0:5:40;
		f5r.Units='centimeters'; f5r.Position=[35 1.5 15 12];
		%export_fig f5r.png -r300
	end
end

[syms]=gSs(symc{1},itn,sbL,fs); syms=syms(pfl+1:end-pfl);
afM=afM(pfl+1:end-pfl); yM=yM(pfl+1:end-pfl);

sss=2; ess=2.3; ss=sss*1e6+itn; es=ess*1e6+itn;
% tt=linspace(sss,ess,es-ss+1); tt=tt(:);

yMH=unwrap(angle(yM(ss:es)))*180/pi; yML=yMH;
yMH(afM(ss:es)<0)=NaN; yML(afM(ss:es)>0)=NaN;
f1l=figure('Color','w');                                                       % plot phase
plot([yMH yML]-angle(yM(ss))*180/pi,'LineWidth',1.2);
ax=gca; ax.ColorOrderIndex=5; hold on; 
plot(unwrap(angle(y(ss:es)))*180/pi-angle(yM(ss))*180/pi,'LineStyle','-.','LineWidth',1.2);
hold off;
ylim([-450 720]); xlim([1 es-ss+1]); grid on;
ax.FontSize=14;
ax.YTick=(-450:90:720); ax.XTick=1:sps:es-ss+1;
ax.XTickLabel=cell(size(ax.XTick));
ax.XTickLabel(1:10:end)=cellstr(num2str((0:5*10:(ess-sss)*1e3+1)'));
ylabel(['\phi ' sprintf('(%c)', char(176))]); xlabel('t (ms)');
f1l.Units='centimeters'; f1l.Position=[35 1.5 15 12];
%export_fig f1l.png -r300
% print('-dpng','-r300','f1l');

afH=afM; afH(afH<0)=NaN; afL=afM; afL(afL>0)=NaN;
f1r=figure('Color','w');                                                        % plot instantaneous frequency
plot([afH(ss:es) afL(ss:es)],'LineWidth',1.2); 
ax=gca; ax.ColorOrderIndex=5; hold on; 
plot(gFA(y(ss:es),fs,1),'LineStyle','-.','LineWidth',1.2);
hold off;
ylim([-55 55]); xlim([1 es-ss+1]); grid on;
ax.FontSize=14;
ax.YTick=(-50:10:50); ax.XTick=1:sps:es-ss+1;
ax.XTickLabel=cell(size(ax.XTick));
ax.XTickLabel(1:10:end)=cellstr(num2str((0:5*10:(ess-sss)*1e3+1)'));
ylabel('f_i (Hz)'); xlabel('t (ms)');
f1r.Units='centimeters'; f1r.Position=[35 1.5 15 12];
%export_fig f1r.png -r300
% print('-dpng','-r300','f1r');

env=abs(y)*1e3;                                                             % amplitude envelope in mV/m
ent=env; ent(~idtn)=NaN;
env(idtn)=NaN; enH=env; enH(bL)=NaN; enL=env; enL(bH)=NaN;
f2l=figure('Color','w'); 
plot(ent(ss:es),'LineStyle','--','Color',[0.77 0.77 0.77]);                 % plot micro-second time resolution amplitude disturbance
grid on; ax=gca; ax.ColorOrderIndex=1; xlim([1 es-ss+1]);
hold on; plot(enH(ss:es),'LineWidth',1.2); hold off
hold on; plot(enL(ss:es),'LineWidth',1.2); hold off
ax.FontSize=14; ylim([0.47 0.61]); ax.YTick=(0.47:0.02:0.61); 
ax.XTick=1:sps:es-ss+1; ax.XTickLabel=cell(size(ax.XTick));
ax.XTickLabel(1:10:end)=cellstr(num2str((0:5*10:(ess-sss)*1e3+1)'));
xlabel('t (ms)'); ylabel('|y_r| (mVm^{-1})');
f2l.Units='centimeters'; f2l.Position=[35 1.5 15 12];
%export_fig f2l.png -r300
% print('-dpng','-r300','f2l');

pd=angle(yr.*conj(yMr))*180/pi; pd=reshape(pd,[],1);                        % phase deviation in degrees
pdt=pd; pdt(~idtn)=NaN;
pd(idtn)=NaN; pdH=pd; pdH(bL)=NaN; pdL=pd; pdL(bH)=NaN;
f2r=figure('Color','w'); 
plot(pdt(ss:es),'LineStyle','--','Color',[0.77 0.77 0.77]);                 % plot micro-second time resolution phase disturbance
grid on; ax=gca; ax.ColorOrderIndex=1; xlim([1 es-ss+1]);
hold on; plot(pdH(ss:es),'LineWidth',1.2); hold off
hold on; plot(pdL(ss:es),'LineWidth',1.2); hold off
ax.FontSize=14; ylim([-6 6]); ax.YTick=(-6:1:6);
ax.XTick=1:sps:es-ss+1; ax.XTickLabel=cell(size(ax.XTick));
ax.XTickLabel(1:10:end)=cellstr(num2str((0:5*10:(ess-sss)*1e3+1)'));
xlabel('t (ms)'); ylabel(['\phi_d ' sprintf('(%c)', char(176))]);
f2r.Units='centimeters'; f2r.Position=[35 1.5 15 12];
%export_fig f2r.png -r300
% print('-dpng','-r300','f2r');

yr(isnan(yr))=0; Yr=fft(yr)./fft(yMr);
tf=[Yr(end+1-fb:end,:);Yr(1:fb,:)];
ff=linspace(-length(tf)/2,length(tf)/2-1,length(tf)); ff=ff.'+fc;

tfa=sum(tf,2);
f3l=figure('Color','w'); 
plot(ff(81:221)*1e-3,abs(tfa(81:221))*1e3/6,'LineWidth',1.2,'Color','k'); grid on;      % plot amplitude spectra
ax=gca; ax.FontSize=14; xlabel('f (kHz)'); ylabel('|h(\omega)| (mVm^{-1})');
ax.ColorOrderIndex=1;
hold on;
plot([ff(201) ff(201)]*1e-3,[0.45 0.61]);
plot([ff(101) ff(101)]*1e-3,[0.45 0.61]);
plot([ff(81) 23403]*1e-3,[.485 .558],'m--');
plot([23403 ff(220)]*1e-3,[.558 .545],'m--');
hold off;
ax.XTick=(23.3375:0.0125:23.4625);
xlim([ff(81) ff(220)]*1e-3);
ylim([0.45 0.61]); ax.YTick=(0.45:0.02:0.61);
ax.XTickLabel=cell(size(ax.XTick));
ax.XTickLabel(2:2:end-1)=cellstr(num2str((23.35:.025:23.45)'));
f3l.Units='centimeters'; f3l.Position=[35 1.5 15 12];
%export_fig f3l.png -r300
% print('-dpng','-r300','f3l');

tp=angle(tfa)*180/pi;
f3r=figure('Color','w'); plot(ff(81:221)*1e-3,tp(81:221),'LineWidth',1.2,'Color','k'); grid on;                 % plot phase spectra
ax=gca; ax.FontSize=14; xlabel('f (kHz)'); 
ylabel(['\angle{h(\omega)} ' sprintf('(%c)', char(176))]);
ax.ColorOrderIndex=1;
hold on;
plot([ff(201) ff(201)]*1e-3,[-7 7]);
plot([ff(101) ff(101)]*1e-3,[-7 7]);
plot([ff(81) 23362]*1e-3,[-1.3 1],'m--');
plot([23362 23437]*1e-3,[1 -1],'m--');
plot([23437 ff(220)]*1e-3,[-1 1.5],'m--');
hold off;
ax.XTick=(23.3375:0.0125:23.4625);
xlim([ff(81) ff(220)]*1e-3); ylim([-7 7]); ax.YTick=(-7:1:7);
ax.XTickLabel=cell(size(ax.XTick));
ax.XTickLabel(2:2:end-1)=cellstr(num2str((23.35:.025:23.45)'));
f3r.Units='centimeters'; f3r.Position=[35 1.5 15 12];
%export_fig f3r.png -r300
% print('-dpng','-r300','f3r');

td=linspace(0,datL*fs/srs-1,datL*fs/srs)*srs/fs; td=td(:);

f4l=figure('Color','w'); plot(td,aM*1e3,'LineWidth',1.2); grid on;              % plot amplitude mode
ylabel('|y_r| (mVm^{-1})'); xlabel('t (s)'); 
ax=gca; ax.FontSize=14; xlim([td(1) td(end)]);
patch([td;flipud(td)],[aM(:,1)-aSD(:,1);flipud(aM(:,1)+aSD(:,1))]*1e3,ax.ColorOrder(1,:),'FaceAlpha',0.3,'EdgeColor','none');
patch([td;flipud(td)],[aM(:,2)-aSD(:,2);flipud(aM(:,2)+aSD(:,2))]*1e3,ax.ColorOrder(2,:),'FaceAlpha',0.3,'EdgeColor','none');
f4l.Units='centimeters'; f4l.Position=[35 1.5 15 12];
%export_fig f4l.png -r300
% print('-dpng','-r300','f4l');

f4r=figure('Color','w'); 
% plot(td,bsxfun(@rdivide,pM,[23350 23450]*2*pi)*1e6,'LineWidth',1.2);      % plot phase mode
plot(td,pM*180/pi,'LineWidth',1.2);                                         % plot phase mode
grid on; ylabel(['\phi_d ' sprintf('(%c)', char(176))]); xlabel('t (s)'); 
ax=gca; ax.FontSize=14; xlim([td(1) td(end)]); ax.YTick=(-1.5:.25:1.5);
patch([td;flipud(td)],[pM(:,1)-pSD(:,1);flipud(pM(:,1)+pSD(:,1))]*180/pi,ax.ColorOrder(1,:),'FaceAlpha',0.3,'EdgeColor','none');
patch([td;flipud(td)],[pM(:,2)-pSD(:,2);flipud(pM(:,2)+pSD(:,2))]*180/pi,ax.ColorOrder(2,:),'FaceAlpha',0.3,'EdgeColor','none');
f4r.Units='centimeters'; f4r.Position=[35 1.5 15 12];
%export_fig f4r.png -r300
% print('-dpng','-r300','f4r');