function [dpM]=psf(sym,sbL,fs)
%PSF pulse shaping filter for VLF GMSK transmissions
%   Gaussian filters a non-return-to-zero binary bit stream to produce the
%   apparent frequency modulation of a VLF GMSK transmission
ns=length(sym); sps=sbL*fs;                                                 % length of each bit and total length of bit stream
bt=0.6; Mod_i=0.5*pi; fb=bt/sbL; r=sqrt(2); sf2=fb^2/2/log(r);              % filter parameters
f=[0:ns/2,ns/2-1:-1:1]'*fs/ns; Gf=exp(-f.^2/2/sf2);                         % calculate Gaussian function
dpM=(ifft(fft(sym).*Gf)*Mod_i/sps)*fs/2/pi;                                 % IIR filter

% FIR filter ??
% span=1; bt=0.6; Mod_i=0.5*pi; h=gaussdesign(bt,span,sps);
% dpM=conv(sym,h,'same')*Mod_i/sps;
% dpM=filter(h,1,sym)*Mod_i/sps;
end