function ya=refadj(yM,ilag,symc,ii,sps,npfl)
%REFADJ align model transitions to continuous reference
%   Detailed explanation goes here
sym=symc{ii};
int=[false;(sym(1:end-1)-sym(2:end))==0];                                   % find symbols that have not changed value from the previous
Mod_i=0.5*pi; ycM=[0;cumsum(sym*Mod_i)];                                    % crude MSK model with transitions on axes (phase)
[ycMi,ycMq]=pol2cart(ycM,1); ycM=ycMi+1j*ycMq;                              % crude MSK model with transitions on axes (complex vector)
yMt=yM(ilag:sps:end); pda=yMt(int)./ycM(int);                               % phase difference between transitions and axes
ya=yM/exp(1j*mean(angle(pda)));                                             % align model so that transitions are on axes

% adjust model so each symbol is in the correct quadrant
if ii>1
    lsym=length(sym);
    symat=cell2mat(symc); symat=reshape(symat,lsym,length(symc));
    qq=sum(symat(1:npfl,1));                                                % sum first bit of first chunk
    qq=qq+sum(sum(symat(npfl+1:end-npfl+1,1:ii-1)));
    pp=ycM(npfl+1)/exp(1j*qq*pi/2);
    ya=ya*pp;
end

end