function [sym]=dGMSK(yc,sps,ilag)   % function [sym,ilag]=dGMSK(yc,sps)
%DGMSK demodulate MSK transmissions V1.0
%   Version history
%   V1.0: transition index estimation now done outside the function
%       Line 15 commented out, changed ilag from output to input
% Inputs:
%   yc - received complex analytic baseband transmission signal
%   sps - samples per symbol
%   fs  - sampling frequency
% parameters for error correction, hard coded here as I don't think they
% need to change
nc=5;		% number of consecutive non-dodgy transitions required to determine transmission validity
et=pi/3;    % error threshold when determining dodgy transitions

% [ilag]=estTn(yc,sps);                                                       % estimate bit transition sample
yc=yc(ilag:sps:end);                                                        % use only transition samples
da=angle(yc(2:end)./yc(1:end-1)); sym=da./abs(da);                          % relative phase movement from transition to transition

% the above is an initial estimate of each symbol
% next, some error correction

% estimate quadrants
Mod_i = 0.5*pi; yM=[0;cumsum(sym*Mod_i)];                                   % crude MSK model with turning points on axes
[yMi,yMq]=pol2cart(yM,1); yM=yMi+1j*yMq;                                    
pd=mean(angle(yc./yM)); yc=yc./exp(1j*pd);                                  % shift transition points to axes by comparing to MSK model
qd=zeros(size(yc));                                                         % initialise (0,0)
iq=angle(yc)>-pi/4&angle(yc)<pi/4; qd(iq)=1+1j;                             % quadrant 1
bs=exp(1j*pi/2); iq=angle(yc/bs)>-pi/4&angle(yc/bs)<pi/4; qd(iq)=-1+1j;     % quadrant 2
bs=exp(1j*pi); iq=angle(yc/bs)>-pi/4&angle(yc/bs)<pi/4; qd(iq,1)=-1-1j;     % quadrant 3
bs=exp(1j*3*pi/2); iq=angle(yc/bs)>-pi/4&angle(yc/bs)<pi/4; qd(iq,1)=1-1j;  % quadrant 4

dgy=abs(angle(qd(1:end-1)./qd(2:end)))>pi-et|abs(angle(qd(1:end-1)./qd(2:end)))<et;	% check for dodgy transitions (true=dodgy)
idgy=(1:length(dgy)); idgy=idgy(dgy); if isempty(idgy), idgy=0; end         % index of dodgy transitions

% if there are dodgy transitions
if idgy(1)~=0
    % work backwards if not enough non-dodgy transitions in the first few bits
    if idgy(1)<nc,
        csc=[idgy(2:end) length(dgy)]-idgy(1:end);		% number of consecutive non-dodgy transitions between dodgy transitions
        csc=idgy(csc>nc); csc=csc(1);	% find the first 5 consecutive non-dodgy transitions
        
        while csc>0
            aa=csc+1; bb=csc; qd(bb)=qd(aa)/exp(1j*sym(bb)*pi/2);
            
            if bb==1, dgy(bb)=abs(angle(qd(bb)./qd(bb+1)))>pi-et|abs(angle(qd(bb)./qd(bb+1)))<et;   % re-compute dodgy transitions
            else dgy(bb-1:bb)=abs(angle(qd(bb-1:bb)./qd(bb:bb+1)))>pi-et|abs(angle(qd(bb-1:bb)./qd(bb:bb+1)))<et;
            end
            idgy=(1:length(dgy)); idgy=idgy(dgy); if isempty(idgy), idgy=0; end
            csc=idgy(idgy<=csc); if csc, csc=csc(end); else csc=0; end
        end
    end
    
    % work forwards to fix dodgy transitions
    while idgy(1)>0
        aa=idgy(1); bb=idgy(1)+1; qd(bb)=qd(aa)*exp(1j*sym(aa)*pi/2);
        
        if aa==length(dgy), dgy(aa)=abs(angle(qd(aa)./qd(aa+1)))>pi-et|abs(angle(qd(aa)./qd(aa+1)))<et;	% re-compute dodgy transitions
        else dgy(aa:aa+1)=abs(angle(qd(aa:aa+1)./qd(aa+1:aa+2)))>pi-et|abs(angle(qd(aa:aa+1)./qd(aa+1:aa+2)))<et;
        end
        idgy=(1:length(dgy)); idgy=idgy(dgy); if isempty(idgy), idgy=0; end
    end
end
da=angle(qd(2:end)./qd(1:end-1)); sym=da./abs(da); % estimate symbols from phase difference polarity