function [bH,bL,idtn]=gsep2(afMr,yMr,ntn)
%gsep get separated symbols for 2d arrays
%   inputs:
%   yM   - MSK/GMSK message signal (complex vector)
%   afM  - apparent frequency of yM (vector)
%   ntn  - number of samples around the transition to exclude in analysis,
%          must be even number (double)
%   outputs:
%   bH   - High in phase is true (bool matrix)
%   bL   - Low in phase is true (bool matrix)
%   idtn - Index of transitioning samples to discard (column vector)

afMr=afMr./abs(afMr);                                                       % make afM + and - (i.e. MSK)
bH=afMr>0; bL=afMr<0;                                                       % vectors of high or low symbols in boolean

% ly=length(yMr); t=linspace(0,ly/fs,ly+1); t=t(1:end-1)';
% rv=exp(1j*Mod_i/sbL*t); rv=rv*exp(-1j*itn/sps*Mod_i);                       % reference vector to distinguish in phase and anti phase, see note on transition point above!
% 
% hh=yMr.*conj(rv); ll=yMr.*rv;
% bHip=(abs(angle(hh))<Mod_i)&bH; bHap=(abs(angle(hh))>Mod_i)&bH;             % high in phase and anti phase (bool)
% bLip=(abs(angle(ll))<Mod_i)&bL; bLap=(abs(angle(ll))>Mod_i)&bL;             % low in phase and anti phase (bool)

idtn=[];
if ntn>0
    daf=[zeros(1,size(afMr,2));diff(afMr)]; idtn=find(daf);                 % index of transitions
    vv=(1:ntn); vv=repmat(vv,size(idtn));
    idtn=bsxfun(@plus,vv,idtn-ntn/2).'; idtn=reshape(idtn,[],1);            % index of transitioning samples to discard
    idtn(idtn<1)=1; idtn(idtn>numel(yMr))=numel(yMr);
    bH=reshape(bH,[],1); bL=reshape(bL,[],1);
    bH(idtn)=false; bL(idtn)=false;
    bH=reshape(bH,size(afMr)); bL=reshape(bL,size(afMr));
end

end