% Script to write sample files for surface elevation extraction
% Opening file
fname = 'system\sampleVOF';
if exist(fname), system('del fname'); end;
fileID = fopen(fname,'w+');

% Writing header
fprintf(fileID,'/*--------------------------------*- C++ -*----------------------------------*\\\n');
fprintf(fileID,'| =========                 |                                                 |\n');
fprintf(fileID,'| \\\\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox           |\n');
fprintf(fileID,'|  \\\\    /   O peration     | Version:  2.1.1                                 |\n');
fprintf(fileID,'|   \\\\  /    A nd           | Web:      www.OpenFOAM.org                      |\n');
fprintf(fileID,'|    \\\\/     M anipulation  |                                                 |\n');
fprintf(fileID,'\\*---------------------------------------------------------------------------*/\n');
fprintf(fileID,'FoamFile\n');
fprintf(fileID,'{\n');
fprintf(fileID,'    version     2.0;\n');
fprintf(fileID,'    format      ascii;\n');
fprintf(fileID,'    class       dictionary;\n');
fprintf(fileID,'    location    "system";\n');
fprintf(fileID,'    object      sampleDict;\n');
fprintf(fileID,'}\n');
fprintf(fileID,'// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //\n\n');

% Interpolation Scheme
fprintf(fileID,'interpolationScheme cellPoint;\n\n');

% Format
fprintf(fileID,'setFormat       raw;\n\n');

% Surface format
fprintf(fileID,'surfaceFormat   raw;\n\n');

% Writing the gauges location
x_pos = 1:1:105;
fprintf(fileID,'sets\n');
fprintf(fileID,'(\n');
% Loop
for i = 1:length(x_pos)
    fprintf(fileID,['    Gauge_',sprintf('%.1f',x_pos(i)),'\n']);
    fprintf(fileID,'    {\n');
    fprintf(fileID,'        type    midPointAndFace;\n');
    fprintf(fileID,'        axis    xyz;\n');
    fprintf(fileID,['        start   ( ',sprintf('%.1f',x_pos(i)),' 0.5 0 );\n']);
    fprintf(fileID,['        end     ( ',sprintf('%.1f',x_pos(i)),' 0.5 4.35 );\n']);
    fprintf(fileID,'    }\n');
end
fprintf(fileID,');\n\n');

% Surfaces
fprintf(fileID,'surfaces        ();\n\n');

% Field to interpolate
fprintf(fileID,'fields          ( alpha1 );\n\n');

% End of file
fprintf(fileID,'// ************************************************************************* //\n');

% Closing file
fclose(fileID);
