clear; clc; path( pathdef );

% structure dimensions
NAME = { '200nm', '250nm', '300nm', '350nm', '400nm', '450nm', '500nm', '550nm', '600nm', '650nm', '700nm', '750nm', '800nm', '850nm', '900nm', '950nm', '1000nm' };

% for the left structure
load( [ pwd, '\left\left_lcc.mat' ] );
load( [ pwd, '\left\left_rcc.mat' ] );
% set up arrays for the sum of the squared absolute values of coupling
% coefficients
left_lcc = zeros( length( NAME ), 2 ); % 1st column = left polarized light, 2nd column = right polarized light
left_rcc = zeros( length( NAME ), 2 );
% loop over all the structures
for iNAME = 1 : length( NAME )
    left_lcc( iNAME, : ) = sum( abs( LCC.( [ 'd', NAME{ iNAME } ] ) ) .^ 2, 1 );
    left_rcc( iNAME, : ) = sum( abs( RCC.( [ 'd', NAME{ iNAME } ] ) ) .^ 2, 1 );
end

% for the right structure
load( [ pwd, '\right\right_lcc.mat' ] );
load( [ pwd, '\right\right_rcc.mat' ] );
% set up arrays for the sum of the squared absolute values of coupling
% coefficients
right_lcc = zeros( length( NAME ), 2 ); % 1st column = left polarized light, 2nd column = right polarized light
right_rcc = zeros( length( NAME ), 2 );
% loop over all the structures
for iNAME = 1 : length( NAME )
    right_lcc( iNAME, : ) = sum( abs( LCC.( [ 'd', NAME{ iNAME } ] ) ) .^ 2, 1 );
    right_rcc( iNAME, : ) = sum( abs( RCC.( [ 'd', NAME{ iNAME } ] ) ) .^ 2, 1 );
end

% plot
figure
plot( 200 : 50 : 1000, ( left_lcc( :, 1 ) - left_rcc( :, 2 ) )./( left_lcc( :, 1 ) + left_rcc( :, 2 ) ), 'rx', 'LineWidth', 3 );
hold on;
plot( 200 : 50 : 1000, ( right_lcc( :, 1 ) - right_rcc( :, 2 ) )./( right_lcc( :, 1 ) + right_rcc( :, 2 ) ), 'bx', 'LineWidth' ,3 );
plot( 200 : 50 : 1000, zeros( 1, length( 200 : 50 : 1000 ) ), 'k--', 'LineWidth', 3 );
xlabel( 'Arm Lengths (nm)', 'FontSize', 16 );
ylabel( 'CD in Coupling Coefficients', 'FontSize', 16 );
set( gca, 'FontSize', 16 );
legend( 'left', 'right' );