clear; clc; pathdef;

% PATH
PATH = pwd;
% polarity
POL = { 'left', 'right' };
% NAME
NAME = { '200nm', '300nm', '400nm', '500nm', '600nm', '700nm', '800nm', '900nm', '1000nm' };
% loop around names
for iPOL = 1 : length( POL )
    for iNAME = 1 : length( NAME )
        % import coupling coefficients
        cc = dlmread( [ PATH, '\', POL{ iPOL }, '\cc_', NAME{ iNAME }, '.txt' ] );
        % import indices
        % left
        indl = dlmread( [ PATH, '\', POL{ iPOL }, '\LCP\', 'ind_', NAME{ iNAME }, '_LCP.txt' ] );
        % right
        indr = dlmread( [ PATH, '\', POL{ iPOL }, '\RCP\', 'ind_', NAME{ iNAME }, '_RCP.txt' ] );
        % left as a reference
        % left and right coupling coefficients
        ccll = cc( indl( :, 1 ), 1 );
        cclr = cc( indl( :, 2 ), 2 );
        % find sums
        totll = sum( ccll .* conj( ccll ) );
        totlr = sum( cclr .* conj( cclr ) );
        % calculate CD
        CD.( POL{ iPOL } ).LCP( iNAME ) = ( totlr - totll )/( totlr + totll );
        % right as a reference
        % left and right coupling coefficients
        ccrl = cc( indr( :, 1 ), 1 );
        ccrr = cc( indr( :, 2 ), 2 );
        % find sums
        totll = sum( ccrl .* conj( ccrl ) );
        totlr = sum( ccrr .* conj( ccrr ) );
        % calculate CD
        CD.( POL{ iPOL } ).RCP( iNAME ) = ( totlr - totll )/( totlr + totll );
    end
end

% plot ( all )
figure
plot( [ 200 300 400 500 600 700 800 900 1000], CD.left.LCP, 'x--', 'LineWidth', 1.5 );
hold on;
plot( [ 200 300 400 500 600 700 800 900 1000], CD.left.RCP, 'x--', 'LineWidth', 1.5 );
plot( [ 200 300 400 500 600 700 800 900 1000], CD.right.LCP, 'x--', 'LineWidth', 1.5 );
plot( [ 200 300 400 500 600 700 800 900 1000], CD.right.RCP, 'x--', 'LineWidth', 1.5 );
xlabel( 'd ( nm )', 'FontSize', 16 );
ylabel( ' CD', 'FontSize', 16 );
set( gca, 'FontSize', 16 );