/*
	Gives S-indices of interface-locations that link [loc, loco] with joint
*/

#include <iostream>
#include <vector>
#include <string>

using namespace std;

#include "modulo.h"
#include "binsearchint.h"
#include "Findloop.h"


Findloop::Findloop()
{
	nonred_amount = 0;				// initialize length of loop by 0 (= empty list)
	amount = 0;						// initialize length of loop_path as 0
	nonred_amounto = 0;
	amounto = 0;
	twist = 0;						// initialize twist of interface as 0 (i.e. try to not twist w.r.t. this orientation)
	prevtwist = 0;					// allow all turns initially
	addlength = -1;					// initialize length added to loop/ loopo, if interface turns out to be longer than expected
	staor = -1;	curor = -1; curoro = -1;// initialize impossible startorientation
	require_periodicity = 0;		// initialize not to need periodicity by default (unless joint is left blank in startsearch)
}


bool Findloop::startsearch( vector<int>* startpt_adr, vector<int>* S_Adr, int NY, int NX, double Tilt, vector<int>* joint_adr, vector<int>* startavoid, int lastlength )
{
	/*
		starts from startpt to walk along (+-)-surface of S and update loop(o), loop(o)_order and loop(o)_path accordingly 
	*/
	// load state-space arguments into private variables:
	S_adr = S_Adr;
	Ny = NY; Nx = NX; tilt = Tilt;
	
	// initialize vectors according to current knowledge:
	int loc = (*startpt_adr).at(0);
	loop_path.clear(); loop_path.reserve(lastlength); loop_path.push_back(loc);
	int loco = (*startpt_adr).at(1);
	loopo_path.clear(); loopo_path.reserve(lastlength); loopo_path.push_back(loco); amount = 1;
	twist = 0; prevtwist = 0;									// initialize twist to be zero, prevtwist (= pervious twist/ twist in last timestep before)) = 0 (i.e. same orientation as startpoints preferred)
	int avoidinversion = 0;
	addlength = int(ceil( lastlength*5e-2 ));					// i.e. 5% of lastlength (purely heuristical)
	bifurcationpts.clear();										// initialize list of all indices of loop(o)_path, where we could have taken another path as well (except for initial points), as well as the current twist back then (ordered according to [loc1, loco1, twist1, loc2, loco2, twist2,...])
	forbidden.clear(); 											// initialize forbidden as empty (ordered as [loc1, loco1, loc2, loco2,...])
	forbidden.push_back(loc); forbidden.push_back(loco);		// add [loc, loco] at first positions of forbidden (reserved for previous-step-locations)
	const int N = Ny*Nx;										// total amount of spins in the Ising-system
	int j = -1;													// initialize indices to walk along loop(o)_path
	int lopt = loc, loopt = loco;								// current positions
	vector<int> twistoptions;									// initialize empty vector for twists for new pathoptions
	vector<int> pathoptions;									// initialize empty vector of all possible paths to go in order [loc1, loco1, loc2, loco2,...]
	int proceed = 0;											// set signpost, if one should proceed on a given pathoption
	vector<int> NNN(8);	NNN.resize(8,-1);						// initialize next-to-nearest-neighbours as -1 (in terms of S-index)
	vector<int> NNNo(8); NNNo.resize(8,-1);						// analogue to NNN for loopt
	int avoidedinterfaceinversion = 0;							// =0, if did not avoid a pathoptions only because of surface-inversion, >0 otherwise
	
	int attempt = 0;

	int erasecounter = 0;										// counts how often parts got erased
	// check if periodicity is wanted:
	vector<int> checkhorizontal(Nx);							// is 0 at location x, if no loop-point at this position, otherwise 1; initialized as constant 0
	if( (*joint_adr).empty()  == 1 )
	{
		joint_adr = startpt_adr;
		require_periodicity = 1;								// i.e. only accept path connecting start- and endpoints, if it's periodic in x-direction (i.e. has at least one point at any x-position)
	}

	// check, if startpoints have different spin-sign:
	if( (*S_adr).at(loc) == (*S_adr).at(loco) )
	{
		cout << "  Warning - startsearch: Startpoints have same spin-sign!\n";
		return 0;
	}

	// get initial orientation:
	staor = getorientation( loc, loco );
	if( staor==-1 )												// i.e. loc and loco are not NN
	{
		return 0;												// running the program doesn't make sense
	}
	else														// i.e. can go on
	{
		curor = staor;											// i.e. current orientation curor = startorientation staor
	}
	// walk along loop(o)_path:
	while( j< (amount-1) )										// i.e. loop(o)_path(j+1) exists, etc (if pathmember could be found, it should be (after j++) j = amount-1
	{
		// set to default start at beginning of new step:
		j++;													// j is inner-loop(o)_path-index: lopt = loop_path(j) = loop_path(amount-1), etc
		lopt = loop_path.at(j); loopt = loopo_path.at(j);		// update lopt and loopt
		twistoptions.clear();									// clear content of twistoptions, so new pathoptions can be added
		pathoptions.clear();									// clear content of pathoptions (i.e. all options to proceed from current loc, loco)
		proceed = 1;											// set proceed to go (unless sth happens)
		avoidedinterfaceinversion = 0;							// did not avoid any pathoptions only because of surface-inversion in this timestep, yet
		NNN = *getNNN( lopt );
		NNNo = *getNNN( loopt );

		// go through different pathoptions, first those that would reduce the twist:
		if( j>0 )
		{
			avoidinversion = (loop_path.at(j-1)==lopt) - (loopo_path.at(j-1)==loopt);
		}
		if( twist == 0 )
		{
			goparallel( lopt, loopt, &NNN, &NNNo, &pathoptions, &twistoptions );
			avoidedinterfaceinversion = avoidedinterfaceinversion + turnclw( lopt, loopt, avoidinversion, &NNN, &NNNo, &pathoptions, &twistoptions );	// order between turnclw and turncclw is arbitrarily set to prefer clw 
			avoidedinterfaceinversion = avoidedinterfaceinversion + turncclw( lopt, loopt, avoidinversion, &NNN, &NNNo, &pathoptions, &twistoptions );
		}
		else if( twist < 0 )
		{
			avoidedinterfaceinversion = avoidedinterfaceinversion + turnclw( lopt, loopt, avoidinversion, &NNN, &NNNo, &pathoptions, &twistoptions );
			goparallel( lopt, loopt, &NNN, &NNNo, &pathoptions, &twistoptions );
			avoidedinterfaceinversion = avoidedinterfaceinversion + turncclw( lopt, loopt, avoidinversion, &NNN, &NNNo, &pathoptions, &twistoptions );
		}
		else // i.e twist > 0
		{
			avoidedinterfaceinversion = avoidedinterfaceinversion + turncclw( lopt, loopt, avoidinversion, &NNN, &NNNo, &pathoptions, &twistoptions );
			goparallel( lopt, loopt, &NNN, &NNNo, &pathoptions, &twistoptions );
			avoidedinterfaceinversion = avoidedinterfaceinversion + turnclw( lopt, loopt, avoidinversion, &NNN, &NNNo, &pathoptions, &twistoptions );
		}
		// check if joint is hit already:
		// to test, if pathoptions only contain NN:
		for( int j_test=0; j_test<twistoptions.size(); j_test++)
		{
			int diffrence = pathoptions.at(2*j_test) - pathoptions.at(1+2*j_test);
			if( modulo(diffrence,Nx) > 1 && modulo(diffrence,Nx) < Nx-1 )
			{
				for( int j_options=0; j_options<twistoptions.size(); j_options++)
				{
					cout << "[ " << pathoptions.at(2*j_options) << ", " << pathoptions.at(1+2*j_options) << ", " << twistoptions.at(j_options) << "]\n";
				}
				cin.get();
			}
		}

		if( pathoptions.empty()==0 )								// i.e. there are pathoptions left
		{
			// check if joint is hit:
			if( pathoptions.at(0)==(*joint_adr).at(0) && pathoptions.at(1)==(*joint_adr).at(1) )
			{
				// check if periodic if require_periodicity is on:
				int isperiodic = 1;									// initialize isperiodic as true and negate if there exists an x without a loop-representation
				if( require_periodicity==1 )						// need to check if periodical
				{
					if( amount>=Nx )								// necessary condition for spanning entire horizontal dimension
					{
						checkhorizontal.resize(Nx,0);				// make sure, that checkhorizontal is initialized with 0 again
						for( int path_j=0; path_j<amount; path_j++)	// walk along horizontal axis
						{
							// only works for Nx>3:
							checkhorizontal.at( modulo(loop_path.at(path_j),Nx) ) = 1;	// set checkhorizontal equal to 1 at those positions, where a loop-point is found with same x-value
						}
						for( int x_j=0; x_j<Nx; x_j++ )
						{
							if( checkhorizontal.at(x_j)==0 )
							{
								isperiodic = 0;						// stop immediately, if an x is found without a corresponding loop-point
								break;
							}
						}
					}
					else											// i.e. necessary condition not valid
					{
						isperiodic = 0;								// not possible to be periodical anymore, as too short
					}
				}
				if( require_periodicity==0 || isperiodic==1 )
				{
					extractloop();
					return 1;										// stop while-loop, to avoid getting more points in loop(o)_path and return 1 to communicate success
				}
				else												// i.e. needs periodicity but is not periodical
				{
					// remove pathoptions from list as otherwise premature joint:
					pathoptions.erase(pathoptions.begin());			// loc-position
					pathoptions.erase(pathoptions.begin());			// loco-position (now first after deleting loc-position)
				}
			}
		}		// end "pathotions.empty() == 0"

		// if no pathoptions available anymore, go back to most recent bifurcation and erase inbetween points:	(need to ask again, as may have removed pathoptions above)
		if( pathoptions.empty()==1 )								// i.e. we must have hit a deadend (or the loop(o) at some bifurcationpoint)
		{
			// forbid this path from other side, too:
			forbidden.push_back(lopt); forbidden.push_back(loopt);
			// make sure we skip the part below, where we would add [pathoptions[1], pathoptions[2]] to the loop(o):
			proceed = 0;
			// send warning, if weird:
			if( bifurcationpts.empty()==1 )							// should not occur, unless wrong startpoints
			{
				return 0;
			}
			erasecounter++;
			// define auxiliary parameters for simplicity of representation:
			int J = bifurcationpts.at(0);
			twist = bifurcationpts.at(1);							// i.e. latest bifurcationdata
			prevtwist = bifurcationpts.at(2);
			// erase all points since that most recent bifurcation:
			int memorize = loop_path.size();
			loop_path.erase( loop_path.begin()+J+1, loop_path.end() );	// erase all points from loop_path, that are younger than the most recent bifurcation
			// ...now the same for loopo_path:
			memorize = loopo_path.size();
			loopo_path.erase( loopo_path.begin()+J+1, loopo_path.end() );	// erase all points from loop_path, that are younger than the most recent bifurcation
			amount = J + 1;
			// make sure, that we are in the same situation again as last time we were at the bifurcation, just knowing the wrong points as stored in forbidden:
			j = J - 1;												// i.e. j++ gives J = amount-1; lopt will be loop_path(J)
			bifurcationpts.erase( bifurcationpts.begin(), bifurcationpts.begin()+3 );	// erase newest bifurcationpoint (might be added again, if still several options to go to (although the failed one is forbidden now))
			if( J > 0 )
			{
				forbidden.at(0) = loop_path.at(J-1);				// new "previous" is set the same it was, when we last were at loop(o)_path.at(J(o))
				forbidden.at(1) = loopo_path.at(J-1);
			}
			else
			{
				forbidden.at(0) = loc;								// or startavoid, if this option is available
				forbidden.at(1) = loco;	
			}
		}		// end "if pathoptions.empty() == 1"
		else	// i.e. there are pathoptions and we can go on
		{
			// set current position [lopt, loopt] as "previous", i.e. not allow it for the next step:
			forbidden.at(0) = lopt; forbidden.at(1) = loopt;
		}

		// add new points to loop etc:
		if( proceed==1 )									// i.e. still pathoptions available
		{
			// update loop-lists:
			int newpt = pathoptions.at(0);					// new point in loop_path, candidate to be added to loop etc
			// update loop_path:
			if( loop_path.capacity()<=amount )				// i.e. would not allow for another entry in current preallocated space
			{
				loop_path.reserve(amount+addlength);		// add a bunch of new storage space
			}
			loop_path.push_back(newpt);
			
			// update loopo-lists:
			int newpto = pathoptions.at(1);					// new point in loopo_path, candidate to be added to loopo etc
			// update loop_path anyways:
			if( loopo_path.capacity()<=amount )				// i.e. would not allow for another entry in current preallocated space
			{
				loopo_path.reserve(amount+addlength);		// add a bunch of new storage space
			}
			loopo_path.push_back(newpto);
			amount = amount + 1;
		
			// add bifurcation, if more pathoptions possible: 
			if( pathoptions.size()>=3 || avoidedinterfaceinversion>0 )		// i.e. more options would have been available (including the ones that would have inverted the interface)(note .size() only works as guaranteed to be non-empty already)
			{
				forbidden.push_back(newpt); forbidden.push_back(newpto);	// if have to jump back to this bifurcation, don't want to make the same mistake twice (note, that they are added at the beginning of forbidden as well, but only until they are overwritten by next step)
				if( bifurcationpts.empty()==0 )								// i.e. currently some bifurcations listed
				{
					bifurcationpts.emplace(bifurcationpts.begin()+0,j);		// newest bifurcations are added at the beginning
					bifurcationpts.emplace(bifurcationpts.begin()+1,twist);
					bifurcationpts.emplace(bifurcationpts.begin()+2,prevtwist);
				}
				else														// i.e. currently no bifurcations listed (should only happen in the very first step)
				{
					bifurcationpts.push_back(j);
					bifurcationpts.push_back(twist);
					bifurcationpts.push_back(prevtwist);
				}
			}

			// update twist:
			prevtwist = twist;												// future prevtwist will be current twist
			twist = twistoptions.at(0);										// new twist is twist of the realized pathoption
		}	// end "if proceed"
	}	// end while loop to walk along loop(o)_path

	cout << "  Warning - startsearch: Exited search without hitting joint!\n";
	return 0;																// must have been not succuessfull, as joint was not hit
}	// end startsearch-function


void Findloop::searchstart( vector<int>* startpt_adr, vector<int>* S_Adr, int NY, int NX, double Tilt, vector<int>* joint_adr, vector<int>* startavoid, int lastlength )
{
	/*
		starts form startpt to search for suitable surfacepoint in same column of S and run startsearch from there on
	*/
	// load state-space arguments into private variables:
	S_adr = S_Adr;
	Ny = NY; Nx = NX; tilt = Tilt; 
	int loc = (*startpt_adr).at(0), loco = (*startpt_adr).at(1);							// initialize loc, loco as given in arguments
	int x = modulo((*startpt_adr).at(0),Nx), xo = modulo((*startpt_adr).at(1),Nx);
	static vector<int> startpt(2); startpt.at(0) = loc; startpt.at(1) = loco;				// need in vector form to use as argument in startsearch
	// give warning if startpoints are not next to each other, if not, give startorientation:
	int jump = getorientation( loc, loco );
	if( jump!=-1 )																			// i.e. make sure, that loc, loco are NN
	{
		jump = modulo(jump,4)/2 + 1;														// jump is 1, if horizontal orientation of [loc, loco], and 2 if vertically oriented
		if( jump==1 )
		{
			cout << "  Warning - searchstart: Given startpoints are in horizontal orientation to each other. Maybe no surface is found...\n";
		}
	}
	else
	{
		return;																				// warning message is in getorientation
	}
	// start search:
	int notyetfound = 1;																	// indicator of search success (1 if not successfull, otherwise 0)
	bool locstillinxrange = 1, locostillinxrange = 1;										// set to zero, if beyond the index range of that column in S	
	while( notyetfound<2*Ny )
	{
		if( locstillinxrange && locostillinxrange && (*S_adr).at(loc)!=(*S_adr).at(loco) )	// i.e. if search can be successfull
		{
			int tata = startsearch( &startpt, S_Adr, NY, NX, Tilt, joint_adr, startavoid, lastlength );
			if( tata!=0 )																	// i.e. if search was indeed successfull (also loads correct loop(o) etc into global variables)
			{
				return;																		// stop trying more startpoints (would overwrite successfull search)
			}
			
		}
		// if no break/ success yet, try new point in closest proximity to the original startpt, that was not yet checked:
		loc = loc + Nx*notyetfound*int(pow(double(-1),double(notyetfound+1))); startpt.at(0) = loc;
		loco = loco + Nx*notyetfound*int(pow(double(-1),double(notyetfound+1))); startpt.at(1) = loco;
		// update progress-variable notyetfound and conditions stillinxrange:
		notyetfound = notyetfound + 1;
		locstillinxrange = ( loc>=x && loc<= (Ny-1)*Nx + x );
		locostillinxrange = ( loco>=xo && loco<= (Ny-1)*Nx + xo );
	}
}

// auxiliary functions:
vector<int>* Findloop::getNNN( int pt )
{
	const int N = Ny*Nx;													// total amount of spins in the Ising-system
	static vector<int> NNN(8);	NNN.resize(8,-1);							// initialize next-to-nearest-neighbours as -1 (in terms of S-index)
	// get NNN of lo(o)pt with same spin-sign, respectively:
	NNN.at(0) = pt-modulo(pt,Nx)+modulo(pt-1,Nx)-Nx*(floor(tilt*modulo(pt-1,Nx))!=floor(tilt*modulo(pt,Nx)));	// NN in West direction of lopt
	NNN.at(2) = modulo(pt-Nx,N);											// NN in North direction of lopt
	NNN.at(4) = pt-modulo(pt,Nx)+modulo(pt+1,Nx)+Nx*(floor(tilt*modulo(pt+1,Nx))!=floor(tilt*modulo(pt,Nx)));	// NN in East direction of lopt
	NNN.at(6) = modulo(pt+Nx,N);											// NN in South direction of lopt
	NNN.at(1) = modulo(NNN.at(0)-Nx,N);										// NN in North direction of NN_w, i.e. NNN in Northwest direction of lopt
	NNN.at(3) = modulo(NNN.at(4)-Nx,N);										// NN in North direction of NN_e
	NNN.at(5) = modulo(NNN.at(4)+Nx,N);										// NN in South direction of NN_e
	NNN.at(7) = modulo(NNN.at(0)+Nx,N);										// NN in South direction of NN_w
	for( int NNN_j=0; NNN_j<8; NNN_j++ )
	{
		if( NNN.at(NNN_j)<0 || NNN.at(NNN_j)>=N || (*S_adr).at( NNN.at(NNN_j) )!=(*S_adr).at( pt ) )	// i.e. opposite sign as spin at lopt
		{
			NNN.at(NNN_j) = -1;												// set to -1 but keep in NNN-list, for keeping track of orientation
		}
	}
	return &NNN;
}

int Findloop::getorientation( int loc, int loco )
{
	/*
		gives -1 if not loc, loco are not NN; 0 if loco is in West direction of loc, 2 if in North direction, 4 if in East direction, 6 if in South direction
	*/
	vector<int> NNN(8);	NNN.resize(8,-1);						// initialize next-to-nearest-neighbours as -1 (in terms of S-index)
	NNN.at(0) = loc-modulo(loc,Nx)+modulo(loc-1,Nx)-Nx*(floor(tilt*modulo(loc-1,Nx))!=floor(tilt*modulo(loc,Nx)));
	NNN.at(2) = modulo(loc-Nx,Ny*Nx);
	NNN.at(4) = loc-modulo(loc,Nx)+modulo(loc+1,Nx)+Nx*(floor(tilt*modulo(loc+1,Nx))!=floor(tilt*modulo(loc,Nx)));
	NNN.at(6) = modulo(loc+Nx,Ny*Nx);
	for(  int NNN_j=0; NNN_j<8; NNN_j+=2)
	{
		if( NNN.at(NNN_j) == loco )
		{
			staor = NNN_j;										// i.e. startortientation staor = 0 if West, 2 if North, 4 if East, 6 if South of lopt
		}
	}
	if( staor == -1 )
	{
		cout << "  Warning - getorientation: Startpoints are not next to each other: [" << loc << ", " << loco << "]\n";
		cout << "   NN of loc are: " << NNN.at(0) << "\t" << NNN.at(2) << "\t"  << NNN.at(4) << "\t" << NNN.at(6) << "\t" << "\n";
	}
	else
	{
		NNN.resize(8,-1);										// reset NNN to default
	}
	return staor;
}

void Findloop::goparallel( int lopt, int loopt, vector<int>* NNN_adr, vector<int>* NNNo_adr, vector<int>* pathoptions_adr, vector<int>* twistoptions_adr )
{
	for( int NNN_j=0; NNN_j<8; NNN_j+=2 )									// don't check diagonal orientations, as only want horizontal (if lo(o)pt are vertical neighbours) or vertical shifts (if otherwise) 
	{
		if( (*NNN_adr).at(NNN_j)!=-1 && (*NNNo_adr).at(NNN_j)!=-1 && giveperm((*NNN_adr).at(NNN_j),(*NNNo_adr).at(NNN_j)) )	// if not already discarded due to wrong sign or forbidden
		{
			(*pathoptions_adr).push_back( (*NNN_adr).at(NNN_j) );
			(*pathoptions_adr).push_back( (*NNNo_adr).at(NNN_j) );			// must be parallel transport, as NNN and NNNo are ordered in the same way
			(*twistoptions_adr).push_back( twist );							// no further twisting relativ to earlier state at [lopt, loopt]
		}
	}
}

bool Findloop::turnclw( int lopt, int loopt, int avoidinversion, vector<int>* NNN_adr, vector<int>* NNNo_adr, vector<int>* pathoptions_adr, vector<int>* twistoptions_adr )
{
	// clw = clockwise (but only with permission and not if surface-inversion):
	bool returnvalue = 0;													// initialize returnvalue, indicating that no pathpossibility was omitted only because of surface-inversion
	curor = modulo(staor + twist,8);										// current orientation, as seen from lopt
	curoro = modulo(curor + 4, 8);											// current orientation, as seen from loopt
	avoidinversion = avoidinversion*(twist-prevtwist==+2);					// -1, if clw turn around loopt is forbidden, +1, if clw turn around lopt is forbidden, 0 else
	if( avoidinversion!=-1 && (*NNNo_adr).at(modulo(curoro-1,8))!=-1 && giveperm(lopt,(*NNNo_adr).at(modulo(curoro-1,8))) )	// turn loopt around lopt if not forbidden (arbitrarily set to prefer turning around lopt)
	{
		(*pathoptions_adr).push_back( lopt );
		(*pathoptions_adr).push_back( (*NNNo_adr).at(modulo(curoro-1,8)) );
		(*twistoptions_adr).push_back( twist+2 );
	}
	else if( (*NNNo_adr).at(modulo(curoro-1,8))!=-1 && giveperm(lopt,(*NNNo_adr).at(modulo(curoro-1,8))) )					// i.e. avoided a point only because of surface-aversion
	{
		returnvalue = 1;
	}
	if( avoidinversion!=+1 && (*NNN_adr).at(modulo(curor-1,8))!=-1 && giveperm((*NNN_adr).at(modulo(curor-1,8)),loopt) )	// turn lopt around loopt if not forbidden
	{
		(*pathoptions_adr).push_back( (*NNN_adr).at(modulo(curor-1,8)) );
		(*pathoptions_adr).push_back( loopt );
		(*twistoptions_adr).push_back( twist+2 );
	}
	else if( (*NNN_adr).at(modulo(curor-1,8))!=-1 && giveperm((*NNN_adr).at(modulo(curor-1,8)),loopt) )						// i.e. avoided a point only because of surface-aversion
	{
		returnvalue = 1;
	}
	return returnvalue;
}

bool Findloop::turncclw( int lopt, int loopt, int avoidinversion, vector<int>* NNN_adr, vector<int>* NNNo_adr, vector<int>* pathoptions_adr, vector<int>* twistoptions_adr )
{
	// cclw = counterclockwise (but only with permission and not if surface-inversion):
	bool returnvalue = 0;													// returnvalue = 1, if no surfaceinversion omitted, 0 otherwise
	curor = modulo(staor + twist,8);										// current orientation, as seen from lopt
	curoro = modulo(curor + 4, 8);											// current orientation, as seen from loopt
	avoidinversion = avoidinversion*(twist-prevtwist==-2);					// -1, if clw turn around loopt is forbidden, +1, if clw turn around lopt is forbidden, 0 else
	if( avoidinversion!=-1 && (*NNNo_adr).at(modulo(curoro+1,8))!=-1 && giveperm(lopt,(*NNNo_adr).at(modulo(curoro+1,8))) )	// turn loopt around lopt if not forbidden (arbitrarily set to prefer turning around lopt)
	{
		(*pathoptions_adr).push_back( lopt );
		(*pathoptions_adr).push_back( (*NNNo_adr).at(modulo(curoro+1,8)) );
		(*twistoptions_adr).push_back( twist-2 );
	}
	else if( (*NNNo_adr).at(modulo(curoro+1,8))!=-1 && giveperm(lopt,(*NNNo_adr).at(modulo(curoro+1,8))) )					// i.e. avoided a point only because of surface-aversion
	{
		returnvalue = 1;
	}
	if( avoidinversion!=+1 && (*NNN_adr).at(modulo(curor+1,8))!=-1 && giveperm((*NNN_adr).at(modulo(curor+1,8)),loopt) )	// turn lopt around loopt if not forbidden
	{
		(*pathoptions_adr).push_back( (*NNN_adr).at(modulo(curor+1,8)) );
		(*pathoptions_adr).push_back( loopt );
		(*twistoptions_adr).push_back( twist-2 );
	}
	else if( (*NNN_adr).at(modulo(curor+1,8))!=-1 && giveperm((*NNN_adr).at(modulo(curor+1,8)),loopt) )						// i.e. avoided a point only because of surface-aversion
	{
		returnvalue = 1;
	}
	return returnvalue;
}

bool Findloop::giveperm( int cand, int cando )
{
	/*
		Checks, if candidate-point [cand, cando] is in forbidden or at a bifurcation, if yes give 0, otherwise 1 
	*/
	if( forbidden.empty()==0 )		// i.e.  there are forbidden zones
	{	
		for( int avoid_j=0; avoid_j<forbidden.size(); avoid_j+=2 )
		{
			if( cand==forbidden.at(avoid_j) && cando==forbidden.at(avoid_j+1) )
			{
				return 0;			// not allowed, if pair is in forbidden
			}
		}
	}
	if( bifurcationpts.empty()==0 )	// i.e. there are recorded bifurcations
	{
		for( int avoid_j=0; avoid_j<bifurcationpts.size()-3; avoid_j+=3 )	// make sure that startpts are not excluded (last three entries in bifurcationpts-list) to allow for joining back
		{
			if( cand==loop_path.at(bifurcationpts.at(avoid_j)) && cando==loopo_path.at(bifurcationpts.at(avoid_j)) )
			{
				return 0;			// not allowed, if pair is at bifurcationpoint (i.e. is in loop(o)_path)
			}
		}
	}
	return 1;
}

void Findloop::extractloop()
{
	/*
		loads loop(o)_path into loop(o) and loop(o)_order
	*/
	// clear all momentary content in loop(o)-lists and allocate enough storage space to refill it:
	loop.clear(); loop.reserve(amount);
	loop_order.clear();	loop_order.reserve(4*amount);
	loopo.clear();	loopo.reserve(amounto);
	loopo_order.clear();	loopo_order.reserve(4*amounto);
	nonred_amount = 0; nonred_amounto = 0;
	// auxiliary variable:
	int pos = -2;										// index-position in loop(o)
	int pathpt = -1;									// value of pathpoint
	int lowstartguess = 0, highstartguess = 0;			// lower and upper initial guess for search in loop(o)
	for( int path_j=0; path_j<amount; path_j++ )
	{
		// check if loop_path.at(path_j) is already in the loop-list:
		pathpt = loop_path.at(path_j);
		lowstartguess = max(0,int(pos-1-Nx/2)); highstartguess = min(nonred_amount-1,int(pos-1+Nx/2));
		pos = binsearchint( &loop, pathpt, lowstartguess, highstartguess );
		if( pos==-1 )									// i.e. lower than all entries so far
		{
			loop.emplace( loop.begin(), pathpt );
			loop_order.emplace( loop_order.begin(), path_j ); loop_order.emplace( loop_order.begin()+1, -1 ); loop_order.emplace( loop_order.begin()+2, -1 ); loop_order.emplace( loop_order.begin()+3, -1 );
			nonred_amount++;
		}
		else if( pos==nonred_amount )					// i.e. larger than all entries so far
		{
			loop.push_back(pathpt);
			loop_order.push_back(path_j); loop_order.push_back(-1); loop_order.push_back(-1); loop_order.push_back(-1); loop_order.push_back(-1);
			nonred_amount++;
		}
		else if( loop.at(pos)==pathpt )					// already mentioned in loop
		{
			for( int order_j=1; order_j<3; order_j++ )	// walk through the entries of loop_order for pathpt and add path_j at first (-1)-entry
			{
				if( loop_order.at(4*pos+order_j)==-1 )
				{
					loop_order.at(4*pos+order_j) = path_j;
					break;
				}
			}
		}
		else											// i.e. stricly between two values of the list (more precisely between pos and (pos+1), i.e. has to be inserted at (pos+1))
		{
			pos = pos + 1;
			loop.emplace( loop.begin()+pos, pathpt );
			loop_order.emplace( loop_order.begin()+4*pos, path_j ); loop_order.emplace( loop_order.begin()+4*pos+1, -1 ); loop_order.emplace( loop_order.begin()+4*pos+2, -1 ); loop_order.emplace( loop_order.begin()+4*pos+3, -1 );
			nonred_amount++;
		}

		// check if loopo_path.at(path_j) is already in the loopo-list:
		pathpt = loopo_path.at(path_j);
		lowstartguess = max(0,int(pos-1-Nx/2)); highstartguess = min(nonred_amounto-1,int(pos-1+Nx/2));
		pos = binsearchint( &loopo, pathpt, lowstartguess, highstartguess );
		if( pos==-1 )									// i.e. lower than all entries so far
		{
			loopo.emplace( loopo.begin(), pathpt );
			loopo_order.emplace( loopo_order.begin(), path_j ); loopo_order.emplace( loopo_order.begin()+1, -1 ); loopo_order.emplace( loopo_order.begin()+2, -1 ); loopo_order.emplace( loopo_order.begin()+3, -1 );
			nonred_amounto++;
		}
		else if( pos==nonred_amounto )					// i.e. larger than all entries so far
		{
			loopo.push_back(pathpt);
			loopo_order.push_back(path_j); loopo_order.push_back(-1); loopo_order.push_back(-1); loopo_order.push_back(-1); loopo_order.push_back(-1);
			nonred_amounto++;
		}
		else if( loopo.at(pos)==pathpt )				// already mentioned in loopo
		{
			for( int order_j=1; order_j<3; order_j++ )	// walk through the entries of loopo_order for pathpt and add path_j at first (-1)-entry
			{
				if( loopo_order.at(4*pos+order_j)==-1 )
				{
					loopo_order.at(4*pos+order_j) = path_j;
					break;
				}
			}
		}
		else											// i.e. stricly between two values of the list (more precisely between pos and (pos+1), i.e. has to be inserted at (pos+1))
		{
			pos = pos + 1;
			loopo.emplace( loopo.begin()+pos, pathpt );
			loopo_order.emplace( loopo_order.begin()+4*pos, path_j ); loopo_order.emplace( loopo_order.begin()+4*pos+1, -1 ); loopo_order.emplace( loopo_order.begin()+4*pos+2, -1 ); loopo_order.emplace( loopo_order.begin()+4*pos+3, -1 );
			nonred_amounto++;
		}
	}
}

// output-functions:
vector<int>* Findloop::getloop()
{
	return &loop;
}
int Findloop::getnonred_amount()
{
	return nonred_amount;
}
vector<int>* Findloop::getloop_order()
{
	return &loop_order;
}
int Findloop::getamount()
{
	return amount;
}
vector<int>* Findloop::getloop_path()
{
	return &loop_path;
}
vector<int>* Findloop::getloopo()
{
	return &loopo;
}
int Findloop::getnonred_amounto()
{
	return nonred_amounto;
}
vector<int>* Findloop::getloopo_order()
{
	return &loopo_order;
}
int Findloop::getamounto()
{
	return amounto;
}
vector<int>* Findloop::getloopo_path()
{
	return &loopo_path;
}