/*
	Binary search of value in an ascendingly ordered int-list; 
	first try to find within the range [lowstarguess, highstartguess]
*/

#include <iostream>
#include <vector>

using namespace std;

int binsearchint( vector<int>* list_adr, double value, int lowstartguess, int highstartguess )
{
	int newpos = -1;					// initialize returnvalue impossibly to indicate it wasn't found
	int l = (*list_adr).size();			// length of list

	// return 0, if list is empty:
	if( l==0 )
	{
		return l;
	}

	// check if low-/highstartguesses are reasonable:
	if( lowstartguess > highstartguess )
	{
		cout << "  Warning - binsearchint: Initial guesses in wrong order - swap them instead\n";
		int tempstore = lowstartguess;
		lowstartguess = highstartguess; highstartguess = tempstore;
	}
	if( lowstartguess >= l || lowstartguess < 0 )
	{
		cout << "  Warning - binsearchint: Initial lower guess out of indexrange - choose default instead\n";
		lowstartguess = ceil(double((l-1)/3));
	}
	if( highstartguess >= l || highstartguess < 0 )
	{
		cout << "  Warning - binsearchint: Initial upper guess out of indexrange - choose default instead\n";
		highstartguess = ceil(double(2*(l-1)/3));
	}
	if( lowstartguess > highstartguess )
	{
		cout << "  Info - binsearchint: New guesses in wrong order - swap them instead\n";
		int tempstore = lowstartguess;
		lowstartguess = highstartguess; highstartguess = tempstore;
	}

	// initialize parameters:
	int bestlowestguess = 0;			// lower bound of index in list
	int besthighestguess = l-1;			// upper bound of index in list
	int currentguess = ceil( double( (lowstartguess+highstartguess)/2 ) );	// current guess of index in list

	// check boundaries:
	if( (*list_adr).at(bestlowestguess) > value )
	{
		return newpos;					// i.e. beyond the list on lower side
	}
	if( (*list_adr).at(bestlowestguess) == value )
	{
		newpos = bestlowestguess;
	}
	if( (*list_adr).at(besthighestguess) < value )
	{
		newpos = l;
		return newpos;					// i.e. beyond the list on uppder side
	}
	if( (*list_adr).at(besthighestguess) == value )
	{
		newpos = besthighestguess;
	}

	// check initial guesses:
	if( (*list_adr).at(lowstartguess) <= value )
	{
		bestlowestguess = lowstartguess;
		if( (*list_adr).at(highstartguess) >= value )
		{
			besthighestguess = highstartguess;
		}
	}
	else								// initial lower guess was too high ==> besthighestguess
	{
		besthighestguess = lowstartguess;
	}

	// run binary search iteration:
	while( newpos == -1 )
	{
		if( (*list_adr).at(currentguess) > value )
		{
			besthighestguess = currentguess;
			currentguess = ceil( double( (bestlowestguess+currentguess)/2 ) );
		}
		else if( (*list_adr).at(currentguess) < value )
		{
			bestlowestguess = currentguess;
			currentguess = ceil( double( (currentguess+besthighestguess)/2 ) );
		}
		else if( (*list_adr).at(currentguess) == value )	// if actually superfluent...
		{
			newpos = currentguess;					// found the index
		}
		if( besthighestguess-bestlowestguess == 1 )	// would be stuck, if just run the algorithm above
		{
			if( (*list_adr).at(besthighestguess) > value )	// ==> rather go for the lower one, if between two values
			{
				newpos = besthighestguess - 1;		// either in between ]bestlowestguess, besthighestguess[ or equal to besthighestguess
			}
			else
			{
				newpos = besthighestguess;			// i.e. list(besthighestguess) == value; this should never happen, as already tested before
			}
		}
		else if( besthighestguess-bestlowestguess == 0 )	// should already be excluded by initial check of boundaries in combination with == value above
		{
			if( besthighestguess == 0 )
			{
				newpos = -1;
			}
			else									// i.e. bestlowestguess == l-1
			{
				newpos = l;							// i.e. out of bounds
			}
		}
	}

	return newpos;
}