/*
	Converts surface to height (by taking highest y-value per x-position)
*/

#include <iostream>		// needed for output in control-window
#include <vector>		// needed for vectors/vector-operations

using namespace std;

#include "modulo.h"		// for periodic boundary-conditions

void converttoheight( vector<int>* Eta_new_adr, vector<int>* loop_adr, int nonred_amount, vector<int>* loopo_adr, int nonred_amounto, vector<int>* S_adr, int Nx, int Ny )
{
	int j_S = -1, x = -1, y = -1;				// initialize position in S

	fill((*Eta_new_adr).begin(), (*Eta_new_adr).end(),-1);	// reset Eta_new;

	if( (*S_adr).at((*loop_adr).at(0)) == +1 )	// loop is positiv, i.e. first "occupied" positions
	{
		for( int j_loop=0; j_loop<nonred_amount; j_loop++ )	// walk along horizontal 
		{
			j_S = (*loop_adr).at(j_loop);		// position in S
			x = modulo(j_S,Nx);					// x-position (i.e. position in Eta_new)
			y = Ny - 1 - j_S/Nx;				// y-position
			if( y>(*Eta_new_adr).at(x) )
			{
				(*Eta_new_adr).at(x) = y;		// found new maximum
			}
		}
	}
	else	// same with loopo instead of loop
	{
		for( int j_loop=0; j_loop<nonred_amounto; j_loop++ )	// walk along horizontal 
		{
			j_S = (*loopo_adr).at(j_loop);		// position in S
			x = modulo(j_S,Nx);					// x-position (i.e. position in Eta_new)
			y = Ny - 1 - j_S/Nx;				// y-position
			if( y>(*Eta_new_adr).at(x) )
			{
				(*Eta_new_adr).at(x) = y;		// found new maximum
			}
		}
	}

	return;
}