/*
	Computes scalar product of argument with filter-function gamma
*/

#include <iostream>		// needed for output in control-window
#include <string>		// needed for strings/names
#include <vector>		// needed for vectors/vector-operations
#include <algorithm>	// needed for max
#include <cmath>		// needed for abs

using namespace std;

void gamma( vector<double>* gamma_im_adr, vector<double>* xrange_adr, int sitenumber, double x0, string type, vector<double>* parameters_adr )
{
	if( type == "wedge" || type == "w" )
	{
		if( (*parameters_adr).size()<2 )
		{
			cout << "Warning - gamma: Too view parameters given\n";
			return;	// escape
		}
		double a = (*parameters_adr).at(0), b = (*parameters_adr).at(1);						// set parameter for filter-function
		int left = (x0-1./b)*sitenumber, right = (x0+1./b)*sitenumber + 1;

		for( int j=0; j<sitenumber; j++ )		// walk along space
		{
			if( j>=left && j<=right )			// within support
			{
				(*gamma_im_adr).at(j) = a* max( 1.-b* abs( (*xrange_adr).at(j) - x0 ), 0. );
			}
			else
			{
				(*gamma_im_adr).at(j) = 0;
			}
		}
	}
	else if( type == "smoothed_wedge" || type == "sw" )
	{
		if( (*parameters_adr).size()<3 )
		{
			cout << "Warning - gamma: Too view parameters given for type " << type << "\n";
			return;	// escape
		}
		double a = (*parameters_adr).at(0), b = (*parameters_adr).at(1), c = (*parameters_adr).at(2);		// set parameters for filter-function (a = height, b = inverse support, c = smoothing)
		int left = (x0-1./b)*sitenumber, right = (x0+1./b)*sitenumber + 1;

		for( int j=0; j<sitenumber; j++ )		// walk along space
		{
			if( j>=left && j<=right )			// within support
			{
				(*gamma_im_adr).at(j) = a* pow(max( 1.-pow(b* abs( (*xrange_adr).at(j) - x0 ),c), 0. ),c);
			}
			else
			{
				(*gamma_im_adr).at(j) = 0;
			}
		}
	}
	else if( type == "double_wedge" || type == "dw" )
	{
		if( (*parameters_adr).size()<2 )
		{
			cout << "Warning - gamma: Too view parameters given\n";
			return;	// escape
		}
		double a = (*parameters_adr).at(0), b = (*parameters_adr).at(1);					// set parameter for filter-function
		int left = (x0-1./b)*sitenumber, right = (x0+2./b)*sitenumber + 1;

		for( int j=0; j<sitenumber; j++ )		// walk along space
		{
			if( j>=left && j<=right )			// within support
			{
				(*gamma_im_adr).at(j) = a* ( max( 1.-b* abs( (*xrange_adr).at(j) - x0 ), 0. ) + max( 1.-b* abs( (*xrange_adr).at(j) - (x0 +1./b) ), 0. ) );
			}
			else
			{
				(*gamma_im_adr).at(j) = 0;
			}
		}
	}
	else if( type == "double_smoothed_wedge" || type == "dsw" )
	{
		if( (*parameters_adr).size()<3 )
		{
			cout << "Warning - gamma: Too view parameters given for type " << type << "\n";
			return;	// escape
		}
		double a = (*parameters_adr).at(0), b = (*parameters_adr).at(1), c = (*parameters_adr).at(2);	// set parameters for filter-function (a = height, b = inverse support, c = smoothing)
		int left = (x0-1./b)*sitenumber, right = (x0+2./b)*sitenumber + 1;

		for( int j=0; j<sitenumber; j++ )		// walk along space
		{
			if( j>=left && j<=right )			// within support
			{
				(*gamma_im_adr).at(j) = a* ( pow(max( 1.-pow(b* abs( (*xrange_adr).at(j) - x0 ),c), 0. ),c) + pow(max( 1.-pow(b* abs( (*xrange_adr).at(j) - (x0 +1./b) ),c), 0. ),c) );
			}
			else
			{
				(*gamma_im_adr).at(j) = 0;
			}
		}
	}
	else
	{
		cout << "Warning - gamma: No valid filter-type selected\n";
	}

	return;
}