/*
	Computes the mean-square-displacement from the originindex and the space- and time-scalings
*/

#include <vector>		// needed for vectors/vector-operations
#include <math.h>		// needed for powers

using namespace std;

double getMSD( vector<vector <int> >* originindex_adr, double dT, double dx )
{
	double MSD = 0, newMSD;					// initialize output
	int span = (*originindex_adr).size();	// total area, over which the particles are spread
	int partcount = 0;						// number of particles already processed for overall MSD

	for( int j_pos=0; j_pos<span; j_pos++ )
	{
		for( int j_part=0; j_part<((*originindex_adr).at(j_pos)).size(); j_part++ )
		{
			newMSD = pow( double(((*originindex_adr).at(j_pos)).at(j_part) - j_pos)*dx, 2. )/dT;	// mean-square-displacement of particle j_part at position j_pos
			MSD = ( MSD*partcount + newMSD )/ (partcount+1);										// update overall mean-square-displacement
			partcount++;																			// just processed another particle
		}
	}

	return MSD;
}