/*
	returns: sum_{i=1..d}[eta(jumpx)-eta(NN_of_jumpx)]
*/

#include <string>		// needed for strings/names
#include <vector>		// needed for vectors/vector-operations

using namespace std;

#include "modulo.h"

double getNNaveragedifference( vector<int>* Eta_new_adr, int sitenumber_dim, int d, int jumpx )
{
	double result = 0;							// initialise the result
	int nn, noeldim, noelnextdim = 1;			// index in Eta_new, where NN of jumpx is located
	for( int j_dim=0; j_dim<d; j_dim++ )		// go through all d dimensions
	{
		noeldim = noelnextdim;
		noelnextdim = noeldim*sitenumber_dim;
		for( int j_dir=0; j_dir<2; j_dir++ )	// go through both directions per dimension
		{
			nn = jumpx - modulo(jumpx,noelnextdim) + modulo( jumpx+(2*j_dir-1)*noeldim, noelnextdim);		// with periodic boundary-conditions
			result += (*Eta_new_adr).at(jumpx) - (*Eta_new_adr).at(nn);
		}
	}

	return result;
}