/*
	Computes the stochastic variable Y
*/

#include <vector>		// needed for vectors/vector-operations
#include <numeric>		// needed for innerproduct
#include <algorithm>	// needed for transform
#include <functional>   // needed for minus
#include <math.h>		// needed for sqrt

using namespace std;

double getY( vector<double>* rho_adr, vector<double>* eta_adr, vector<double>::iterator gamma_im_start, int sitenumber, double epsilon )
{
	double Y = 0;					// initialize the result and set epsilon
	vector<double> diff(sitenumber);
	transform ((*rho_adr).begin(), (*rho_adr).end(), (*eta_adr).begin(), diff.begin(), minus<double>());	// subtracts: rho-eta
	Y = inner_product(diff.begin(), diff.end(), gamma_im_start, 0.);										// L^2-scalar product: diff*gamma
	Y = Y/sqrt(epsilon);			// scale with sqrt(epsilon)

	return Y;						// L^2-scalar product: diff*gamma
}