/*
	converts the "determenistic" state rho_old into a discrete eta_old
*/

#include <iostream>		// needed for output in control-window
#include <string>		// needed for strings/names
#include <vector>		// needed for vectors/vector-operations
#include <random>		// needed for random-number-generator

using namespace std;

#include "binsearch.h"
#include "g.h"

void getEta_old( vector<int>* Eta_old_adr, vector<double>* Rho_old_adr, int Nbin, int micres, int Npart, string type, string initializationtype )
{
	if( initializationtype == "nowait"  )
	{
		cout << " (Info getEta_old: " << initializationtype << " activated) ";
		// for zero-range-processes without wait:
		random_device rd;
		mt19937_64 seed(rd());
		uniform_real_distribution<double> distribution(0.0,1.0);
		double randno = 0;
		vector<double> cumsum(2);
		cumsum.at(0) = 0;		// first entry in cumsum is always zero
		cumsum.at(1) = 1;		// cumsum.at(1) = cumsum(k=0) = 1
		double Z = 0;			// partition function
		double phi = -1;
		int maxlength = 0;		// maximum amount of paritcles possible at one site
		double add = 0;			// difference between two successors in the cumsum
		for( int j=0; j<Nbin*micres; j++ )
		{
			if( (*Rho_old_adr).at(j) != phi )		// need to re-calculate cumsum and Z
			{
				phi = (*Rho_old_adr).at(j);
				maxlength = phi + 20*sqrt(phi);
				cumsum.resize(maxlength);
				add = 1;
				for( int k=1; k<maxlength-1; k++ )	// go through all particles up until cutoff
				{
					add = add*phi/g(k);
					cumsum.at(k+1) = cumsum.at(k) + add;	// "k" particles-case is in "k+1" position in cumsum-vector
				}
				Z = cumsum.at(maxlength-1);			// last element of cumsum
			}
			randno = distribution(seed);			// create new random number
			(*Eta_old_adr).at(j) = binsearch( &cumsum, randno*Z, 0, maxlength-1) -1;	// "-1" as in the k-particles position in cumsum is at the (k+1)th position in the vector
		}
	}
	else if( micres==0 && type != "SEP" )			// just take rounded version of rho_old as eta_old
	{
		for( int j=0; j<Nbin; j++ )					// walk along (mi/acroscopical) state
		{
			(*Eta_old_adr).at(j) = int(1+floor( (*Rho_old_adr).at(j)-0.5 ));	// add another point at the end (rounded version of rho_old at this position)
		}
	}
	else if( micres>=1 || type == "SEP" )			// interpolate with random-numbers and expectation of rho_old
	{
		// initialize random distribution:
		random_device rd;
		mt19937_64 seed(rd());
		uniform_real_distribution<double> distribution(0.0,1.0);
		double randno = 0;
		// initilialize corresponding macroscopical position:
		int J = -1;
		for( int j=0; j<Nbin*micres; j++ )			// walk along microscopical state
		{
			J = j/micres;							// gets rounded down automatically by cutoff due to "int"
			randno = distribution(seed);			// create new random number
			(*Eta_old_adr).at(j) = int(floor( (*Rho_old_adr).at(J) ));
			if( randno<(*Rho_old_adr).at(J)-(*Eta_old_adr).at(j) )		// place a particle with probability proportional to rho
			{
				(*Eta_old_adr).at(j) += 1;
			}
			else									// don't place a particle
			{
				(*Eta_old_adr).at(j) += 0;
			}
		}
	}
	else
	{
		cout << "  Warning - getEta_old: No valid choice of micres: " << micres << "\n";
	}
	return;
}