/*
	Creates filename for statefiles from physical/ numerical data
*/

#include <iostream>		// needed for output in control-window
#include <string>		// needed for strings/names
#include <sstream>		// needed for ostringstream

using namespace std;

#include "translate.h"

string getfilename( double dT, int Nbin, int micres, int Npart, int sampling, int fsampling, int samplesize, double wait, double fwait, string type, string mode, string repeattype, string name )
{
	ostringstream filenamestream;						// creates stream-buffer
	filenamestream << "state (" << type << ", dT=" << dT << ", Nbin=" << Nbin << ", micres=" << micres << ", Npart=" << Npart << ", allsamples=" << sampling << "x" << fsampling << "x" << samplesize << ", wait=" << wait << ", fwait=" << fwait << ", " << mode << ", " << translate(repeattype,"shorten") << ", " << name << ").txt";

	return filenamestream.str();						// name of file, the state is written into
}