/*
	Computes the jump-rates in the Kawasaki-model for a given configuration
*/

#include <iostream>		// needed for output in control-window
#include <vector>		// needed for vectors/vector-operations

using namespace std;

#include "modulo.h"		// for periodic boundary-conditions
#include "getNNaveragedifference.h"

void getjumprates( vector<int>* Eta_new_adr, vector<double>* rate_adr, int jumpx, int sitenumber_dim, int d, double beta )
{
	double avdiffatjump, avdiffatnn, diffprob;						// exp( (local) hamiltonian after hypothetical jump - before )
	int noeldim, noelnextdim, nn;									// number of elements up to specific dimension ( noeldim = pow(sitenumber_dim,j_dim) ); index of nearest neighbour in Eta_new

	avdiffatjump = getNNaveragedifference( Eta_new_adr, sitenumber_dim, d, jumpx );
	noelnextdim = 1;												// reset noelnextdim at beginning of next dimension-loop
	for( int j_dim=0; j_dim<d; j_dim++ )
	{
		noeldim = noelnextdim;
		noelnextdim = noeldim*sitenumber_dim;
		for( int j_dir=0; j_dir<2; j_dir++ )						// for jump to the left/right in j_dim-direction
		{
			nn = jumpx - modulo(jumpx,noelnextdim) + modulo( jumpx+(2*j_dir-1)*noeldim, noelnextdim);	// with periodic boundary-conditions
			avdiffatnn = getNNaveragedifference( Eta_new_adr, sitenumber_dim, d, nn );
			// update jump-rates from neighbour to jumpx:
			if( (*Eta_new_adr).at(nn)!=0 )							// only applies, if there is a particle at nnx
			{
				diffprob = exp( -2.*beta*(avdiffatjump-avdiffatnn+double(2*d+1)) );
				(*rate_adr).at(2*d*nn + 2*j_dim + (1-j_dir)) = diffprob/(diffprob+1.);
			}
			else													// otherwise no jump can happen, so jumprate is zero
			{
				(*rate_adr).at(2*d*nn + 2*j_dim + (1-j_dir)) = 0;
			}
			// update jump-rates from jumpx to neighbour:
			if( (*Eta_new_adr).at(jumpx)!=0 )						// only applies, if there is still a particle left
			{
				diffprob = exp( -2.*beta*(avdiffatnn-avdiffatjump+double(2*d+1)) );
				(*rate_adr).at(2*d*jumpx + 2*j_dim + j_dir) = diffprob/(diffprob+1.);
			}
			else													// otherwise no jump can happen, so jumprate is zero
			{
				(*rate_adr).at(2*d*jumpx + 2*j_dim + j_dir) = 0;
			}
		}
	}	// end dimension-loop for updating rates around jumpx

	return;
}