/*
	Returns local mean of nearest-neighbour spins
*/

#include <iostream>		// needed for output in control-window
#include <string>		// needed for strings/names
#include <vector>		// needed for vectors/vector-operations

using namespace std;

#include "getneighbour.h"	// for finding neighbour

double getlocalmean( int loc, vector<int>* S_adr, int Nx, int Ny, double tilt, string boundarycondition )
{
	double localmean = 0;	// initialize output variable
	int nn = -1;			// location-index of neighbour (in S)

	for( int nndirection=0; nndirection<4; nndirection++ )	// go through all nearest neighbours
	{
		nn = getneighbour(loc, nndirection, Nx, Ny, tilt, boundarycondition);
		localmean += (*S_adr).at(nn);
	}
	localmean = localmean*0.25;

	return localmean;
}