/*
	Returns neighbour of location in Spin-matrix
*/

#include <iostream>		// needed for output in control-window
#include <string>		// needed for different profile-types

using namespace std;

#include "modulo.h"		// for periodic boundary-conditions

int getneighbour( int jumpfrom, int direction, int Nx, int Ny, double tilt, string boundarycondition )
{
	int jumpto = -1;	// initialize output-location

	if( 1 )				// for boundary-condition
	{
		if( direction == 0)	// jump North
		{
			jumpto = jumpfrom - Nx;	// no periodic boundary-conditions
		}
		else if( direction == 1 )	// jump East
		{
			jumpto = jumpfrom - modulo(jumpfrom,Nx) + modulo(jumpfrom+1,Nx);
			jumpto = jumpto + Nx*( floor(double(tilt*jumpto))-floor(double(tilt*jumpfrom)) );	// if at threshold of discrete tilting, compensate for coordinate-transformation (ie. cutting off the edges)
		}
		else if( direction == 2 )	// jump South
		{
			jumpto = jumpfrom + Nx;	// no periodic boundary-conditions
		}
		else if( direction == 3 )	// jump West
		{
			jumpto = jumpfrom - modulo(jumpfrom,Nx) + modulo(jumpfrom-1,Nx);
			jumpto = jumpto + Nx*( floor(double(tilt*jumpto))-floor(double(tilt*jumpfrom)) );
		}
		else
		{
			cout << " Warning - getneighbour: No valid direction (from " << jumpfrom << "): " << direction << "\n";
			return -1;
		}
	}

	return jumpto;
}