/*
	Computes the rho, weighted by gamma
*/

#include <vector>		// needed for vectors/vector-operations
#include <numeric>		// needed for innerproduct
#include <math.h>		// needed for powers

using namespace std;

#include "gamma.h"
#include "modulo.h"

double getrho_a( vector<double>* rho_adr, int sitenumber, vector<double>::iterator gammasq_start, int interpolationref )
{
	double rho_a = 0;						// initialize variable
	
	rho_a =  inner_product((*rho_adr).begin(), (*rho_adr).end(), gammasq_start, 0.)/accumulate(gammasq_start, gammasq_start+sitenumber, 0.) *interpolationref;
	
	return rho_a;
}