/*
	Initializes the deterministic state rho_old as defined here
*/

#define _USE_MATH_DEFINES	// needed for M_PI

#include <iostream>		// needed for output in control-window
#include <vector>		// needed for vectors/vector-operations
#include <string>		// needed for different profile-types
#include <cmath>		// needed for sin, M_PI

using namespace std;

void getrho_old( vector<double>* rho_old_adr, int sitenumber, int Npart, string profile )
{
	double scaling = double(Npart)/sitenumber;	// deterministic scaling law for rho

	if( profile == "flat" )
	{
		fill((*rho_old_adr).begin(),(*rho_old_adr).end(),scaling);
	}
	else if( profile == "sin" )
	{
		for( int j=0; j<sitenumber; j++)
		{
			(*rho_old_adr).at(j) = scaling*sin(M_PI*j/(sitenumber-1));
		}
	}
	else if( profile == "1-cos" )
	{
		for( int j=0; j<sitenumber; j++)
		{
			(*rho_old_adr).at(j) = scaling*0.5*(1-cos(2.0*M_PI*j/(sitenumber-1)));
		}
	}
	else if( profile == "sintrans" )
	{
		double A = 1;
		for( int j=0; j<sitenumber; j++ )
		{
			(*rho_old_adr).at(j) = scaling+5*sin( 2.0*M_PI*(double(j)/(sitenumber-1)-0.5)/A );
		}
	}
	else if( profile == "costrans" )
	{
		double A = 0.1;
		for( int j=0; j<sitenumber; j++ )
		{
			(*rho_old_adr).at(j) = scaling*0.5*(1+cos( 2.0*M_PI*(double(j)/(sitenumber-1)-0.5)/A ));
		}
	}
	else
	{
		cout << " Warning - getrho-old: Unknown profile '" << profile << ".'\n";
	}

	return;
}