/*
	Computes the diffusivity from Y, rho, F and gamma
*/

#include <vector>		// needed for vectors/vector-operations
#include <numeric>		// needed for innerproduct
#include <math.h>		// needed for powers

using namespace std;

#include "getF.h"
#include "gamma.h"
#include "modulo.h"

double getsigma( double Y_old, double Y_new, vector<double>* rho_adr, double dT, vector<double>::iterator gammasq_start, double Dx )
{
	double sigma = 0, Fss = 0;				// initialize variables
	
	Fss = ( getF(Y_old+Dx)+getF(Y_old-Dx)-2*getF(Y_old) )/(Dx*Dx);	// second derivative of F at Y
	sigma = ( getF(Y_new) - getF(Y_old) ) / ( 0.5 * dT * Fss * inner_product((*rho_adr).begin(), (*rho_adr).end(), gammasq_start, 0.) );
	
	return sigma;
}