/*
	Saves input to external text-files after taking the modulo of powers of ten
*/

#include <iostream>		// needed for output in control-window
#include <sstream>		// needed for ostringstream
#include <fstream>		// needed for output to external files
#include <string>		// needed for strings/names

using namespace std;

void saverandomnumber( double randno )
{
	int powerrange[] = {0,5,6,7,8,9,10,12};		// powers with which the random-number gets multiplied
	int l_pwers = int( sizeof(powerrange)/sizeof(powerrange[0]) );	// amount of elements in powerrange
	double mr = -1;						// for multiple of random number randno
	stringstream textfilename;			// name of textfile

	for( int j_pwers=0; j_pwers<l_pwers; j_pwers++ )
	{
		// get entry for file:
		mr = randno*pow(10.,double(powerrange[j_pwers]));
		mr = mr - int(mr);				// get rid of integer part
		// get filename:
		textfilename.str("");			// reset name to empty
		textfilename << "random-number  x e" << powerrange[j_pwers] << ".txt";
		// append respective file with entry:
		ofstream textfile( textfilename.str(), ofstream::app );	// opens (to append)/ creates file "filename", referred to as textfile here
		textfile.precision(10);			// set precision up to ten digits (unless limited by floatfield)
		if( textfile.is_open() )		// just check to be save...
		{
			textfile << mr << ",\t";
		}
		else							// sth went wrong
		{
			cout << "  Warning - saverandomnumber: Could not open a textfile to save state!\n(" << textfilename.str() << ")\n";
		}
	}

	return;
}