/*
	Saves the results by appending a textfile
*/

#include <iostream>		// needed for output in control-window
#include <fstream>		// needed for output to external files
#include <ctime>		// needed for timer
#include <string>		// needed for strings/names
#include <vector>		// needed for vectors/vector-operations

using namespace std;

void saveresultstotext( double x0range[], const int lx0range, double refinement, vector<double>* eta_a_adr, vector<double>* rho_a_adr, vector<double>* sigma_adr, vector<double>* stdderr_adr, vector<double>* drhodT_adr, vector<double>* diametent_adr, vector<double>* stderr_diametent_adr, string statefilename, clock_t starttime, int storagelength, string filtertype, vector<double>* filterparameters_adr, string interpolationtype, int interpolationref, string samplingmode, int sampling, int fsampling )
{
	string filename = "C++ results.txt";				// name of file, where results will be saved in
	ofstream textfile( filename, ofstream::app );		// opens (to append)/ creates file "filename", referred to as textfile here
	if( textfile.is_open() )							// just check to be save...
	{
		textfile.precision(10);							// set precision up to ten digits (unless limited by floatfield)
		// get current date:
		time_t currenttime = time(0);					// get current time
		struct tm* today = localtime(&currenttime);		// get (pointer to) current time in day-month-year-format
		textfile << "_____" << today->tm_mday << ". " << today->tm_mon +1 << ". " << today->tm_year +1900 << "_____\n";	// write current date
		// write name of corresponding state-file:
		textfile << statefilename << "\n";
		// write sampling:
		textfile << "samplingxfsampling:\t" << sampling << "x" << fsampling << " (" << samplingmode << ")\n";
		// write refinement:
		textfile << "interpolation:\t\trefinement: " << refinement << "\ttype: " << interpolationtype << " , interpolationref = " << interpolationref <<   "\n";
		// write filter-paramters:
		textfile << "filter-parameters:";
		for( int j_filter=0; j_filter<(*filterparameters_adr).size(); j_filter++ )
		{
			textfile << "\t" << (*filterparameters_adr).at(j_filter);
		}
		textfile << "\t" << "(" << filtertype << ")";
		textfile << "\n";
		// write x0, where gamma concentrated:
		textfile << " x0:\t";
		for( int j_x0=0; j_x0<lx0range; j_x0++ )
		{
			textfile << "\t" << x0range[j_x0];
		}
		textfile << "\n";
		// write initial positions (weighted with gamma):
		textfile << " eta_old_a:";
		for( int j_eta=0; j_eta<(*eta_a_adr).size(); j_eta++ )
		{
			textfile << "\t" << (*eta_a_adr).at(j_eta);
		}
		textfile << "\n";
		// write final positions (weighted with gamma):
		textfile << " rho_new_a:";
		for( int j_rho=0; j_rho<(*rho_a_adr).size(); j_rho++ )
		{
			textfile << "\t" << (*rho_a_adr).at(j_rho);
		}
		textfile << "\n";
		// write sigma:
		textfile << " sigma(rho(x)):";
		for( int j_sigma=0; j_sigma<(*sigma_adr).size(); j_sigma++ )
		{
			textfile << "\t" << (*sigma_adr).at(j_sigma);
		}
		textfile << "\n";
		// write standard-error of sigma:
		textfile << " stdderr:";
		for( int j_err=0; j_err<(*stdderr_adr).size(); j_err++ )
		{
			textfile << "\t" << (*stdderr_adr).at(j_err);
		}
		textfile << "\n";
		// write drho/dt:
		textfile << " <g,drho/dt>:";
		for( int j_err=0; j_err<(*drhodT_adr).size(); j_err++ )
		{
			textfile << "\t" << (*drhodT_adr).at(j_err);
		}
		textfile << "\n";
		// write diagonal metric entry:
		textfile << " diametent:";
		for( int j_err=0; j_err<(*diametent_adr).size(); j_err++ )
		{
			textfile << "\t" << (*diametent_adr).at(j_err);
		}
		textfile << "\n";
		// write standard-error of diagonal metric entry:
		textfile << " sterdiametent:";
		for( int j_err=0; j_err<(*stderr_diametent_adr).size(); j_err++ )
		{
			textfile << "\t" << (*stderr_diametent_adr).at(j_err);
		}
		textfile << "\n";
		// write storagelength and (approximate) time-consumption: (so far)
		clock_t endtime = clock();						// stop-time for timer
		textfile << " Time-consumption so far with storagelength = " << storagelength << ": " << double(endtime-starttime)/ CLOCKS_PER_SEC << " sec.\n\n";

		textfile.close();								// close textfile again
	}
	else												// sth went wrong
	{
		cout << "  Warning - saveresultstotext: Could not open a textfile to save state!\n(" << filename << ")\n";
	}

	return;
}