/*
	Creates textfile and writes (particle-) states in textfile in the order
	final states (i.e. value\tvalue\t...x\nvalue\t...)
	with terminator and new line between storages
*/

#include <iostream>		// needed for output in control-window
#include <sstream>		// needed for ostringstream
#include <fstream>		// needed for output to external files
#include <string>		// needed for strings/names
#include <vector>		// needed for vectors/vector-operations

using namespace std;

#include "getfilename.h"

void savestatetotext( vector<double>* storage_adr, double dT, vector<double>* boundaries_adr, int Nbin, int micres, int Npart, int sampling, int fsampling, int samplesize, double wait, double fwait, string type, string mode, string repeattype, string name, bool init )
{
	int l = (*storage_adr).size();						// length of storage-vector (storagelength*Nmic)
	string filename = getfilename(dT, Nbin, micres, Npart, sampling, fsampling, samplesize, wait, fwait, type, mode, repeattype, name);
	ofstream textfile( filename, ofstream::app );		// opens (to append)/ creates file "filename", referred to as textfile here
	if( textfile.is_open() )							// just check to be save...
	{
		if( init )										// i.e. want to initialize header of file, too
		{
			textfile << "dT:\t\t" << dT << "\n";
			textfile << "boundaries:\t" << (*boundaries_adr).at(0) << "\t" << (*boundaries_adr).at(1) << "\n";
			textfile << "Nbin:\t\t" << Nbin << "\n";
			textfile << "micres:\t\t" << micres << "\n";
			textfile << "Npart:\t\t" << Npart << "\n";
			textfile << "samplesize:\t" <<  samplesize << "\n";
			textfile << "fsampling:\t" << fsampling << "\n";
			textfile << "sampling:\t" << sampling << "\n";
			textfile << "wait:\t\t" << wait << "\n";
			textfile << "fwait:\t\t" << fwait << "\n";
			textfile << "mode:\t\t" << mode << "\n";
			textfile << "repeattype:\t" << repeattype << "\n";
			textfile << "name:\t\t" << name << "\n";
		}
		for( int j=0; j<l; j++ )						// walk along entries if storage
		{
			textfile << (*storage_adr).at(j) << "\t";	// write entry of storage and separate from next one by "\t"
		}
		textfile << "x\n";								// set terminator
		textfile.close();								// close textfile again
	}
	else												// sth went wrong
	{
		cout << "  Warning - savestatetotext: Could not open a textfile to save state!\n(" << filename << ")\n";
	}

	return;
}