/*
	Writes all physical data of the current state (i.e. system-size, time, spin-configuration) as well as timestep in a textfile
*/

#include <iostream>
#include <fstream>
#include <ctime>
#include <vector>

using namespace std;

#include "savetotext.h"

void savetotext( const int Ny, const int Nx, const double tilt, const double T, const double h, const int t, double time, int shift, vector<int>* S_adr)
{
	char filename[100];
	sprintf(filename, "Spin-State (%dx%d, tilt=%1.2f, T=%1.2f, h=%1.1f, t=%d, time=%1.3f).txt", Ny, Nx, tilt, T, h, t, time );
	ofstream textfile( filename );
	if( textfile.is_open() )					// just check to be save...
	{
		textfile << "Ny:\t" << Ny << "\n";		// amount of spins in vertical direction
		textfile << "Nx:\t" << Nx << "\n";		// amount of spins in horizontal direction
		textfile << "tilt:\t" << tilt << "\n";	// tilt of periodic boundary conditions
		textfile << "T:\t"	<< T << "\n";		// temperature
		textfile << "h:\t" << h << "\n";		// bias/ external force
		textfile << "t:\t" << t << "\n";		// amount of timesteps
		textfile << "time:\t" << time << "\n";	// physical time of the model process
		textfile << "shift:\t" << shift << "\n";// amount of timesteps
		for ( int j=0; j<Ny*Nx; j++)
		{
			textfile << (*S_adr).at(j) << "\t";	// write spins rowwise
			if ( (j+1)%Nx == 0 )
			{	
				textfile << "\n";
			}
		}
		textfile.close();						// close textfile again
	}
	else										// sth went wrong
	{
		cout << "  Warning - savetotext: Could not open a textfile to save state!\n";
	}
}