/*
	Computes the diffusivity from Y, rho, F and gamma
*/

#include <iostream>		// needed for output in control-window
#include <vector>		// needed for vectors/vector-operations
#include <numeric>		// needed for innerproduct
#include <math.h>		// needed for powers

using namespace std;

#include "getF.h"
#include "gamma.h"
#include "modulo.h"

double getsigma( double Y_old, double Y_new, vector<double>* rho_adr, double dT, vector<double>::iterator gammasq_start, double Dx )
{
	double sigma = 0, Fss = 0;				// initialize variables (impossibly)
	
	Fss = ( getF(Y_old+Dx)+getF(Y_old-Dx)-2*getF(Y_old) )/(Dx*Dx);	// second derivative of F at Y
	int sitenumber = distance( (*rho_adr).begin(), (*rho_adr).end() );
	vector<double> approximation(sitenumber);
	for( int j_rho=0; j_rho<sitenumber; j_rho++ )
	{
		approximation.at(j_rho) = (*rho_adr).at(j_rho);
	}
	sigma = ( getF(Y_new) - getF(Y_old) ) / ( 0.5 * dT * Fss * inner_product(approximation.begin(), approximation.end(), gammasq_start, 0.) );
	
	return sigma;
}